program dclockpanel;

{$MODE OBJFPC}
{$LONGSTRINGS ON}
{$RANGECHECKS ON}
{$SMARTLINK ON}
{$ASMMODE INTEL}

uses
  cthreads, classes, sysutils, x, xlib, xutil, xatom, ctypes;

type
  TGt = class(TThread)
  public
    procedure AfterConstruction; override;
    procedure Execute; override;
  end;

const
  WND_X = 300;
  WND_Y = 50;
  WND_WDT = 800;
  WND_HGH = 600;
  WND_BORDER_WDT = 5;
  WND_TITLE = 'Clock panel';
  PRG_CLASS = 'ClockPanel';

var
  prDisplay: PDisplay;
  nScreenNum: Integer;
  prGC: TGC;
  rEvent: TXEvent;
  nWnd: TWindow;
  gt: TThread;
  font, fontBig, fontSm: TFont;
  year, month, day, hour, minute: Integer;
  inittime: Boolean = False;
  colorBlue, colorRed, colorGreen: TXColor;

procedure TGt.AfterConstruction;
begin
  inherited AfterConstruction;
  FreeOnTerminate := True;
end;

procedure TGt.Execute;
var
  t: TSystemTime;
begin
  while True do
  begin
    GetLocalTime(t);
    if (year <> t.Year) or (month <> t.Month) or (day <> t.Day) or (hour <> t.Hour) or (minute <> t.Minute) then
    begin
      year := t.Year;
      month := t.Month;
      day := t.Day;
      hour := t.Hour;
      minute := t.Minute;
      inittime := True;
      XClearWindow(prDisplay, nWnd);
      XFlush(prDisplay);
    end;
    Sleep(1000);
  end;
end;

begin
  XInitThreads;
  prDisplay := XOpenDisplay(nil);
  if prDisplay = nil then
  begin
    Writeln('Cannot connect to the X server!');
    Halt(1);
  end;

  nScreenNum := XDefaultScreen(prDisplay);
  font := XLoadFont(prDisplay, '-*-helvetica-bold-r-normal-*-300-*-*-*-*-*-koi8-r');
  fontSm := XLoadFont(prDisplay, '-*-helvetica-bold-r-normal-*-240-*-*-*-*-*-koi8-r');
  fontBig := XLoadFont(prDisplay, '-*-helvetica-bold-r-normal-*-400-*-*-*-*-*-koi8-r');

  nWnd := XCreateSimpleWindow(prDisplay, XRootWindow(prDisplay, nScreenNum), WND_X, WND_Y, WND_WDT, WND_HGH, WND_BORDER_WDT, XWhitePixel(prDisplay, nScreenNum), XWhitePixel(prDisplay, nScreenNum));
  XMapWindow(prDisplay, nWnd);
  XSelectInput(prDisplay, nWnd, ExposureMask or KeyPressMask or ButtonPressMask or StructureNotifyMask);

  XAllocNamedColor(prDisplay, DefaultColormap(prDisplay, nScreenNum), 'blue', @colorBlue, @colorBlue);
  XAllocNamedColor(prDisplay, DefaultColormap(prDisplay, nScreenNum), 'red', @colorRed, @colorRed);
  XAllocNamedColor(prDisplay, DefaultColormap(prDisplay, nScreenNum), 'green', @colorGreen, @colorGreen);

  XSync(prDisplay, True);
  gt := TGt.Create(True);
  gt.Start;

  while True do
  begin
    XNextEvent(prDisplay, @rEvent);
    case rEvent._type of
      Expose:
        begin
          if not inittime then Continue;
          XClearWindow(prDisplay, nWnd);
          prGC := XCreateGC(prDisplay, nWnd, 0, nil);

          { Часы - чёрный }
          XSetForeground(prDisplay, prGC, XBlackPixel(prDisplay, nScreenNum));
          XSetFont(prDisplay, prGC, fontBig);
          XDrawString(prDisplay, nWnd, prGC, 10, 100, PChar(IntToStr(hour) + ':' + IntToStr(minute)), 5);

          { Месяц - синий }
          XSetForeground(prDisplay, prGC, colorBlue.pixel);
          XSetFont(prDisplay, prGC, font);
          XDrawString(prDisplay, nWnd, prGC, 10, 200, PChar(IntToStr(month)), 2);

          { День недели - красный }
          XSetForeground(prDisplay, prGC, colorRed.pixel);
          XSetFont(prDisplay, prGC, font);
          XDrawString(prDisplay, nWnd, prGC, 10, 300, PChar(IntToStr(day)), 2);

          { Год - зелёный }
          XSetForeground(prDisplay, prGC, colorGreen.pixel);
          XSetFont(prDisplay, prGC, fontSm);
          XDrawString(prDisplay, nWnd, prGC, 10, 400, PChar(IntToStr(year)), 4);

          XFreeGC(prDisplay, prGC);
        end;
      KeyPress:
        begin
          XCloseDisplay(prDisplay);
          Halt(0);
        end;
    end;
  end;
end.