program dclockpanel_ai2;

{$MODE OBJFPC}
{$LONGSTRINGS ON}
{$RANGECHECKS ON}
{$SMARTLINK ON}
{$ASMMODE INTEL}

uses
  sysutils, x, xlib, xutil, xatom, ctypes;

const
  WND_X = 300;
  WND_Y = 50;
  WND_WDT = 800;
  WND_HGH = 600;
  WND_BORDER_WDT = 5;
  WND_TITLE = 'Clock panel';
  PRG_CLASS = 'ClockPanel';

var
  prDisplay: PDisplay;
  nScreenNum: Integer;
  prGC: TGC;
  rEvent: TXEvent;
  nWnd: TWindow;
  font, fontBig, fontSm: TFont;
  year, month, day, hour, minute: Integer;
  inittime: Boolean = False;
  colorBlue, colorRed, colorGreen: TXColor;

procedure UpdateTime;
var
t: TSystemTime;
sEvent: TXEvent;
begin
  GetLocalTime(t);
  year := t.Year;
  month := t.Month;
  day := t.Day;
  hour := t.Hour;
  minute := t.Minute;
  inittime := True;
//  XClearWindow(prDisplay, nWnd);
//  XFlush(prDisplay);
sevent.xexpose._type := Expose;
sevent.xexpose.x := 0;
sevent.xexpose.y := 0;
sevent.xexpose.width := 150;
sevent.xexpose.height := 150;
sevent.xexpose.count := 0;
XSendEvent(prdisplay, nwnd, true, 0, @sevent);
XFlush(prdisplay);
end;

begin
  prDisplay := XOpenDisplay(nil);
  if prDisplay = nil then
  begin
    Writeln('Cannot connect to the X server!');
    Halt(1);
  end;

  nScreenNum := XDefaultScreen(prDisplay);
  font := XLoadFont(prDisplay, '-*-helvetica-bold-r-normal-*-300-*-*-*-*-*-koi8-r');
  fontSm := XLoadFont(prDisplay, '-*-helvetica-bold-r-normal-*-240-*-*-*-*-*-koi8-r');
  fontBig := XLoadFont(prDisplay, '-*-helvetica-bold-r-normal-*-400-*-*-*-*-*-koi8-r');

  nWnd := XCreateSimpleWindow(prDisplay, XRootWindow(prDisplay, nScreenNum), WND_X, WND_Y, WND_WDT, WND_HGH, WND_BORDER_WDT, XWhitePixel(prDisplay, nScreenNum), XWhitePixel(prDisplay, nScreenNum));
  XMapWindow(prDisplay, nWnd);
  XSelectInput(prDisplay, nWnd, ExposureMask or KeyPressMask or ButtonPressMask or StructureNotifyMask);

  XAllocNamedColor(prDisplay, DefaultColormap(prDisplay, nScreenNum), 'blue', @colorBlue, @colorBlue);
  XAllocNamedColor(prDisplay, DefaultColormap(prDisplay, nScreenNum), 'red', @colorRed, @colorRed);
  XAllocNamedColor(prDisplay, DefaultColormap(prDisplay, nScreenNum), 'green', @colorGreen, @colorGreen);

  XSync(prDisplay, True);

  while True do
  begin
    UpdateTime;
    XNextEvent(prDisplay, @rEvent);
    case rEvent._type of
      Expose:
        begin
          if not inittime then Continue;
          XClearWindow(prDisplay, nWnd);
          prGC := XCreateGC(prDisplay, nWnd, 0, nil);

          { Часы - чёрный }
          XSetForeground(prDisplay, prGC, XBlackPixel(prDisplay, nScreenNum));
          XSetFont(prDisplay, prGC, fontBig);
          XDrawString(prDisplay, nWnd, prGC, 10, 100, PChar(IntToStr(hour) + ':' + IntToStr(minute)), 5);

          { Месяц - синий }
          XSetForeground(prDisplay, prGC, colorBlue.pixel);
          XSetFont(prDisplay, prGC, font);
          XDrawString(prDisplay, nWnd, prGC, 10, 200, PChar(IntToStr(month)), 2);

          { День недели - красный }
          XSetForeground(prDisplay, prGC, colorRed.pixel);
          XSetFont(prDisplay, prGC, font);
          XDrawString(prDisplay, nWnd, prGC, 10, 300, PChar(IntToStr(day)), 2);

          { Год - зелёный }
          XSetForeground(prDisplay, prGC, colorGreen.pixel);
          XSetFont(prDisplay, prGC, fontSm);
          XDrawString(prDisplay, nWnd, prGC, 10, 400, PChar(IntToStr(year)), 4);

          XFreeGC(prDisplay, prGC);
        end;
      KeyPress:
        begin
          XCloseDisplay(prDisplay);
          Halt(0);
        end;
    end;
    Sleep(1000);
  end;
end.