unit fakunit;

interface

uses time;

function Fak(Day: TDay; Month: TMonth; Year: Int64): Int64;
function WeekdayRuFak(y: Int64; m: TMonth; d: TDay): TWeekDayRu;

implementation

function Fak(Day: TDay; Month: TMonth; Year: Int64): Int64;
var
  M3, Y3: Int64;
begin
  if Month > 2 then
  begin
    M3 := (4 * Month + 9) div 10;  // Убираем вещественные вычисления
    Y3 := Year;
  end
  else
  begin
    M3 := 0;
    Dec(Y3);
  end;

  Exit(365 * Year + Day + 31 * (Month - 1) - M3 + (Y3 shr 2) 
       - ((Y3 div 100) - (Y3 div 400)));  // Коррекция високосных годов
end;

function WeekdayRuFak(y: Int64; m: TMonth; d: TDay): TWeekDayRu;
const
  WeekdayMap: array[0..6] of TWeekDayRu = (6, 7, 1, 2, 3, 4, 5);
var
  wd: Int64;
begin
  wd := Fak(d, m, y) mod 7;
  if wd < 0 then wd := (wd + 7) mod 7;  // Коррекция для отрицательных значений
  Exit(WeekdayMap[wd]);
end;

{
Отлично! А может ли быть в чём-то полезна для класса TGORG64Event приведённая нами ранее в порядок функция Fak ?
ChatGPT сказал:

Функция Fak (факториал) сама по себе не связана с обработкой дат и времени, но её можно применить в специфических случаях внутри класса TGORG64Event. Вот несколько идей:
1. Расчёт комбинаций для работы с повторяющимися событиями

Если у тебя есть повторяющиеся события, например, расписание встреч, то можно использовать факториал для вычисления комбинаций.
Пример: вычисление комбинаций событий

Допустим, у нас есть n дней и мы хотим выбрать k событий (например, важные встречи). Количество возможных комбинаций рассчитывается как:
C(n,k)=n!k!(n−k)!
C(n,k)=k!(n−k)!n!

Это можно применить для автоматического расчёта, сколько разных расписаний можно составить:

function TGORG64Event.EventCombinations(n, k: Integer): Int64;
begin
  if (k > n) or (n < 0) or (k < 0) then
    Exit(0);
  Result := Fak(n) div (Fak(k) * Fak(n - k));
end;

✅ Где может пригодиться?

    Если пользователь выбирает несколько событий в определённом диапазоне дат.
    Если мы генерируем случайное расписание на основе фиксированного количества доступных дней.

2. Определение уникальности событий на основе факториала

Если события пронумерованы, можно использовать Fak для быстрого получения уникального хэш-идентификатора.
Пример: Генерация уникального идентификатора

function TGORG64Event.UniqueEventID: Int64;
begin
  Result := Fak(year mod 10) + Fak(month) + Fak(day);
end;

✅ Что это даёт?

    Быстрое сравнение событий (если ID совпадают, события идентичны).
    Оптимизация работы с хэш-таблицами, если храним события в структуре данных.

3. Оптимизация календарных расчётов через факториал

В календарных вычислениях часто используются разбиения на подмножества (например, "каждые 5 дней"). Факториал может помочь быстро определять интервалы.
Пример: Чётные и нечётные периоды

Допустим, мы хотим выделять "особые" дни в зависимости от факториала месяца:

function TGORG64Event.IsSpecialDay: Boolean;
begin
  Result := (day mod Fak(month) = 0);
end;

✅ Что это даёт?

    Можно автоматически отмечать особые дни, например, дни, кратные факториалу номера месяца.

4. Определение "красивых дат" через факториал

Некоторые пользователи любят "особые" даты. Например:

    Дни, когда номер месяца делится на факториал дня.
    Дни, когда сумма цифр факториала года равна номеру месяца.

Пример: Проверка "красивости" даты

function TGORG64Event.IsBeautifulDate: Boolean;
begin
  Result := (year mod Fak(day) = month);
end;

✅ Где может пригодиться?

    Выделение особых дней (например, для астрологии или календарных приложений).
    Фильтр дат (например, находить "красивые даты" для предложений).

5. Генерация псевдослучайных чисел на основе факториала

Факториал можно использовать как источник больших чисел. Например, если Fak(day) достаточно велик, то его можно применять для уникальной генерации номеров.
Пример: Генерация случайного номера события

function TGORG64Event.GenerateRandomEventNumber: Int64;
begin
  Result := Fak(day) mod 1000000; // Ограничиваем 6 знаками
end;

✅ Что это даёт?

    Можно использовать для генерации ID событий.
    Можно создавать уникальные порядковые номера для записей.

Вывод

🔥 Факториал можно эффективно использовать в TGORG64Event для:

    Вычисления комбинаций событий (EventCombinations).
    Генерации уникальных ID (UniqueEventID).
    Оптимизации календарных расчётов (IsSpecialDay).
    Определения "красивых дат" (IsBeautifulDate).
    Генерации случайных номеров событий (GenerateRandomEventNumber).

👉 Таким образом, Fak оказался полезным не только в математике, но и в календарных вычислениях! 🚀
}

end.