unit xshape;
interface
uses ctypes, x, xlib, xutil;
{$packrecords C}
{$linklib Xext}
const
  libxext = 'Xext';
const
  X_ShapeQueryVersion	=	0;
  X_ShapeRectangles	=	1;
  X_ShapeMask		=	2;
  X_ShapeCombine	=	3;
  X_ShapeOffset		=	4;
  X_ShapeQueryExtents	=	5;
  X_ShapeSelectInput	=	6;
  X_ShapeInputSelected	=	7;
  X_ShapeGetRectangles	=	8;
  ShapeSet		=	0;
  ShapeUnion		=	1;
  ShapeIntersect	=	2;
  ShapeSubtract		=	3;
  ShapeInvert		=	4;
  ShapeBounding		=	0;
  ShapeClip		=	1;
  ShapeInput		=	2;
  ShapeNotifyMask	= 1; 
  ShapeNotify		= 0;
  ShapeNumberEvents	= (ShapeNotify + 1);
type
  XShapeEvent = record
    type_: cint;      
    serial: culong;   
    send_event: cbool;
    display: PDisplay;
    window: TWindow;  
    kind: cint;	      
    x, y: cint;	      
    width, height: cunsigned;
    time: x.TTime;    
    shaped: cbool     
  end;
  ctime = cint;
function XShapeQueryExtension(
  dpy: PDisplay;        
  event_basep: pcint;	
  error_basep: pcint	
): cbool; cdecl; external libxext;
function XShapeQueryVersion (
  dpy: PDisplay;	
  major_versionp: pcint;
  minor_versionp: pcint 
): xlib.TStatus; cdecl; external libxext;
procedure XShapeCombineRegion (
  dpy: PDisplay; 
  dest: TWindow; 
  destKind: cint;
  xOff: cint;    
  yOff: cint;    
  r: xutil.TRegion;
  op: cint       
); cdecl; external libxext;
procedure XShapeCombineRectangles (
  dpy: PDisplay;     
  dest: TWindow;     
  destKind: cint;    
  xOff: cint;	     
  yOff: cint;	     
  rects: PXRectangle;
  n_rects: cint;     
  op: cint;	     
  ordering: cint     
); cdecl; external libxext;
procedure XShapeCombineMask (
  dpy: PDisplay; 
  dest: TWindow; 
  destKind: cint;
  xOff: cint;	 
  yOff: cint;	 
  src: x.TPixmap;
  op: cint 	 
); cdecl; external libxext;
procedure XShapeCombineShape (
  dpy: PDisplay; 
  dest: TWindow; 
  destKind: cint;
  xOff: cint;	 
  yOff: cint;	 
  src: TWindow;	 
  srcKind: cint; 
  op: cint	 
); cdecl; external libxext;
procedure XShapeOffsetShape (
  dpy: PDisplay; 
  dest: TWindow; 
  destKind: cint;
  xOff: cint;	 
  yOff: cint 	 
); cdecl; external libxext;
function XShapeQueryExtents (
  dpy: PDisplay;  
  window: TWindow;
  bShaped: pcbool;
  xbs: pcint;	  
  ybs: pcint;	  
  wbs: pcuint;	  
  hbs: pcuint;	  
  cShaped: cbool; 
  xcs: pcint;	  
  ycs: pcint;	  
  wcs: pcuint;	  
  hcs: pcuint	  
): xlib.TStatus; cdecl; external libxext;
procedure XShapeSelectInput (
  dpy: PDisplay;  
  window: TWindow;
  longmask: culong
); cdecl; external libxext;
function XShapeInputSelected (
  dpy: PDisplay;  
  window: TWindow 
): culong; cdecl; external libxext;
function XShapeGetRectangles (
  dpy: PDisplay;  
  window: TWindow;
  kind: cint;     
  count: pcint;	  
  ordering: pcint 
): PXRectangle; cdecl; external libxext;
implementation
end.
