#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <stdio.h>

GdkFilterReturn filter(GdkXEvent *xevent, GdkEvent *event, gpointer data) {
    XKeyEvent *ev = (XKeyEvent *)xevent;
    if(ev->type == 2) {
        printf("Backspace hit.\n");
    }

    return GDK_FILTER_CONTINUE;
}

int main(int argc, char *argv[]) {
    gtk_init(&argc, &argv);

    GdkScreen *scr = gdk_screen_get_default();
    GdkWindow *groot = gdk_screen_get_root_window(scr);
    gdk_window_set_events(groot, GDK_KEY_PRESS_MASK);
    gdk_window_add_filter(groot, filter, NULL);

    Display *d = gdk_x11_get_default_xdisplay();
    Window root = GDK_WINDOW_XID(groot);
    int keycode = XKeysymToKeycode(d, XK_BackSpace);
    XGrabKey(d, keycode, AnyModifier, root, 1, GrabModeAsync, GrabModeAsync);

    gtk_main();
}