procedure TFPWMBorder.eventButton(e: PXButtonEvent);
var
  event: TXEvent;
  found: Boolean;
  done: Boolean;
  x: Integer;
  y: Integer;
  action: Integer;
  buttonSize: Integer;
  tdiff: culong = 0;
begin
  {$ifdef FPWM_TRACE}
  FPWMTrace('[TFPWMBorder.eventButton]');
  {$endif}
  if (e^.window = m_parent) then
  begin
    {$ifdef FPWM_TRACE}
    FPWMTrace('[TFPWMBorder.eventButton] (e^.window = m_parent)');
    {$endif}
    if (not m_client.isActive()) then Exit();
    if (isTransient()) then
    begin
      if ((e^.x >= xIndent()) and (e^.y >= yIndent())) then
      begin
	Exit();
      end
      else
      begin
	m_client.move(e);
	Exit();
      end;
    end;
    m_client.moveOrResize(e);
    Exit();
  end
  else if (e^.window = m_tab) then
  begin
    {$ifdef FPWM_TRACE}
    FPWMTrace('[TFPWMBorder.eventButton] (e^.window = m_tab)');
    {$endif}
    m_client.move(e);
    Exit();
  end;
  if (e^.window = m_resize) then
  begin
    {$ifdef FPWM_TRACE}
    FPWMTrace('[TFPWMBorder.eventButton] (e^.window = m_resize)');
    {$endif}
    m_client.resize(e, True, True);
    Exit();
  end;
  if (e^.window <> m_button) or (e^._type = ButtonRelease) then Exit();
  if (windowManager().attemptGrab(m_button, None, MenuGrabMask, e^.time)
    <> GrabSuccess) then
  begin
    Exit();
  end;
  done := False;
  x := e^.x;
  y := e^.y;
  action := 1;
  buttonSize := m_tabWidth - TAB_TOP_HEIGHT*2 - 4;
  {$ifdef FPWM_TRACE}
  FPWMTrace(Format('[TFPWMBorder.eventButton] XFillRectangle m_tabWidth=%d buttonSize=%d',
    [m_tabWidth, buttonSize]));
  {$endif}
  XFillRectangle(display(), m_button, m_drawGC, 0, 0, buttonSize, buttonSize);
  while (not done) do
  begin
    found := False;
    if (tdiff > CONFIG_DESTROY_WINDOW_DELAY) and (action = 1) then
    begin
      windowManager().installCursor(DeleteCursor);
      action := 2;
    end;
    while (XCheckMaskEvent(display(), MenuMask, @event)) do
    begin
      found := True;
      if (event._type <> MotionNotify) then break;
    end;
    if (not found) then
    begin
      Sleep(50);
      tdiff := tdiff +50;
      continue;
    end;
    case event._type of
    Expose: windowManager().eventExposure(@event.xexpose);
    ButtonPress:
    begin
    end;
    ButtonRelease:
    begin
      if (not nobuttons(@event.xbutton)) then begin
	action := 0;
      end;
      if (x < 0) or (y < 0) or (x >= buttonSize) or (y >= buttonSize) then begin
	action := 0;
      end;
      windowManager().releaseGrab(@event.xbutton);
      done := True;
    end;
    MotionNotify:
    begin
      tdiff := event.xmotion.time - e^.time;
      if (tdiff > 5000) then tdiff := 5001; 
      x := event.xmotion.x;
      y := event.xmotion.y;
      if (action = 0) or (action = 2) then
      begin
	if (x < 0) or (y < 0) or (x >= buttonSize) or (y >= buttonSize) then
        begin
	  windowManager().installCursor(NormalCursor);
	  action := 0;
	end
        else
        begin
	  windowManager().installCursor(DeleteCursor);
	  action := 2;
	end;
      end;
    end;
    else
      WriteLn(Format('fpwm: unknown event type %d', [event._type]));
    end;
  end;
  XClearWindow(display(), m_button);
  windowManager().installCursor(NormalCursor);
  if (tdiff > 5000) then Exit(); 
  if (action = 1) then m_client.hide()
  else if (action = 2) then m_client.kill();
end;