unit fpwmgeneral;
{$mode delphi}
interface
{$include fpwmdefines.inc}
uses
  SysUtils,
  x, xlib, baseunix, unix;
{$include fpwmconfig.inc}
{$include fpwmcursors.inc}
const
  TAB_TOP_HEIGHT  = 2;
  FRAME_WIDTH = CONFIG_FRAME_THICKNESS;
  TRANSIENT_FRAME_WIDTH  = 4;
type
  SIGNAL_CALLBACK_TYPE = SigActionHandler; 
  TAtoms = record
    wm_state: TAtom;
    wm_changeState: TAtom;
    wm_protocols: TAtom;
    wm_delete: TAtom;
    wm_takeFocus: TAtom;
    wm_colormaps: TAtom;
    fpwm_running: TAtom;
  end;
var
  Atoms: TAtoms;
  ignoreBadWindowErrors: Boolean = False; 
procedure fpwm_signal(x: cint; y: SigActionHandler);
{$ifdef FPWM_TRACE}
procedure FPWMTrace(AStr: string);
{$endif}
implementation
procedure fpwm_signal(x: cint; y: SigActionHandler);
var
  sAct: SigActionRec;
begin
  fpsigemptyset(sAct.sa_mask);
  sAct.sa_flags := 0;
  sAct.sa_handler := y;
  fpsigaction(x, @sAct, nil);
end;
{$ifdef FPWM_TRACE}
var
  TraceFile: TextFile;
procedure FPWMTrace(AStr: string);
begin
  WriteLn(TraceFile, AStr);
  {$ifndef FPWM_TRACE_TO_FILE}
  Flush(TraceFile);
  {$endif}
end;
{$endif}
{$ifdef FPWM_TRACE}
initialization
  {$ifdef FPWM_TRACE_TO_FILE}
  AssignFile(TraceFile, 'fpwmlog.txt');
  ReWrite(TraceFile);
  {$else}
  TraceFile := Output;
  {$endif}
finalization
  {$ifdef FPWM_TRACE_TO_FILE}
  CloseFile(TraceFile);
  {$endif}
{$endif}
end.