{%MainUnit fpwmmanager.pas}

function TFPWMBorder.parent(): TWindow;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMBorder.parent]');
  {$endif}
  Result := m_parent;
end;

function TFPWMBorder.hasWindow(w: TWindow): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMBorder.hasWindow]');
  {$endif}
  Result := (w <> root()) and
    ((w = m_parent) or (w = m_tab) or (w = m_button) or (w = m_resize));
end;

function TFPWMBorder.yIndent(): cint;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMBorder.yIndent]');
  {$endif}
  if isTransient() then
    Result := TRANSIENT_FRAME_WIDTH + 1
  else
    Result := FRAME_WIDTH + 1;
end;

function TFPWMBorder.xIndent(): cint;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMBorder.xIndent]');
  {$endif}
  if isTransient() then
    Result := TRANSIENT_FRAME_WIDTH + 1
  else
    Result := m_tabWidth + FRAME_WIDTH + 1;
end;

