#include <gtk/gtk.h>
#include <math.h>
#include <time.h>
// Ok
#define CLOCK_MARGIN 10

typedef struct {
    GtkWidget *drawing_area;
} AppData;

static void on_draw(GtkDrawingArea *area, cairo_t *cr, int width, int height, gpointer user_data) {
    time_t rawtime = time(NULL);
    struct tm *timeinfo = localtime(&rawtime);

    double center_x = width / 2.0;
    double center_y = height / 2.0;
    double radius = fmin(width, height) / 2.0 - CLOCK_MARGIN;

    // Белый фон
    cairo_set_source_rgb(cr, 1, 1, 1);
    cairo_paint(cr);

    // Циферблат
    cairo_set_source_rgb(cr, 0, 0, 0);
    cairo_set_line_width(cr, 4);
    cairo_arc(cr, center_x, center_y, radius, 0, 2 * M_PI);
    cairo_stroke(cr);

    // Деления
    for (int i = 0; i < 12; ++i) {
        double angle = i * G_PI / 6.0;
        double x1 = center_x + (radius - 10) * sin(angle);
        double y1 = center_y - (radius - 10) * cos(angle);
        double x2 = center_x + radius * sin(angle);
        double y2 = center_y - radius * cos(angle);
        cairo_move_to(cr, x1, y1);
        cairo_line_to(cr, x2, y2);
    }
    cairo_stroke(cr);

    // Углы стрелок
    double seconds = timeinfo->tm_sec * G_PI / 30;
    double minutes = (timeinfo->tm_min + timeinfo->tm_sec / 60.0) * G_PI / 30;
    double hours = (timeinfo->tm_hour % 12 + timeinfo->tm_min / 60.0) * G_PI / 6;

    // Часовая
    cairo_set_line_width(cr, 6);
    cairo_move_to(cr, center_x, center_y);
    cairo_line_to(cr, center_x + (radius * 0.5) * sin(hours), center_y - (radius * 0.5) * cos(hours));
    cairo_stroke(cr);

    // Минутная
    cairo_set_line_width(cr, 4);
    cairo_move_to(cr, center_x, center_y);
    cairo_line_to(cr, center_x + (radius * 0.75) * sin(minutes), center_y - (radius * 0.75) * cos(minutes));
    cairo_stroke(cr);

    // Секундная (красная)
    cairo_set_source_rgb(cr, 1, 0, 0);
    cairo_set_line_width(cr, 2);
    cairo_move_to(cr, center_x, center_y);
    cairo_line_to(cr, center_x + (radius * 0.9) * sin(seconds), center_y - (radius * 0.9) * cos(seconds));
    cairo_stroke(cr);
}

static gboolean on_timeout(gpointer user_data) {
    AppData *app = (AppData *)user_data;
    gtk_widget_queue_draw(app->drawing_area);
    return G_SOURCE_CONTINUE;
}

static void activate(GtkApplication *app, gpointer user_data) {
    AppData *data = g_new0(AppData, 1);

    GtkWidget *window = gtk_application_window_new(app);
    gtk_window_set_title(GTK_WINDOW(window), "Glock (GTK4)");
    gtk_window_set_default_size(GTK_WINDOW(window), 240, 240);
    gtk_window_set_resizable(GTK_WINDOW(window), FALSE);

    data->drawing_area = gtk_drawing_area_new();
    gtk_drawing_area_set_draw_func(GTK_DRAWING_AREA(data->drawing_area), on_draw, data, NULL);

    gtk_window_set_child(GTK_WINDOW(window), data->drawing_area);
    gtk_widget_set_visible(window, TRUE);

    g_timeout_add_seconds(1, on_timeout, data);
}

int main(int argc, char *argv[]) {
    GtkApplication *app = gtk_application_new("org.example.glock", G_APPLICATION_DEFAULT_FLAGS);
    g_signal_connect(app, "activate", G_CALLBACK(activate), NULL);
    int status = g_application_run(G_APPLICATION(app), argc, argv);
    g_object_unref(app);
    return status;
}