#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <stdbool.h>

int main(int argc, char **argv)
{
   Display *display;
   XEvent event;
   bool quit = false;

   if (NULL==(display=XOpenDisplay(NULL))) {
      return 1;
   }

   XGrabKeyboard(display, DefaultRootWindow(display),
                 True, GrabModeAsync, GrabModeAsync, CurrentTime);
   
   char *s;
   unsigned int kcode;
   while(!quit)
   {
      XNextEvent(display, &event);// получаем событие
      switch (event.type) {// обрабатываем
         case KeyPress:
            kcode = ((XKeyPressedEvent*)&event)->keycode;
            s = XKeysymToString(XKeycodeToKeysym(display, kcode, 0));
            if (s) 
                printf("KEY:%d %s\n", kcode, s);
            if (kcode == 24) 
                quit=true;
            //XSync(display, False);
            //XFlush(display);
            //XUngrabKeyboard(display, CurrentTime);
            
            break;
         case ButtonPress:
             printf("bp");
             break;
         case ButtonRelease:
             printf("br");
             break;
         case KeyRelease:
             printf("kr");
             break;
         default:
            break;
      }
      XSendEvent(display, 0, 0, 0, &event);//посылаем куда-то
   }

   XUngrabKeyboard(display, CurrentTime);

   if (XCloseDisplay(display)) {
      return 1;
   }

   return 0;
}