program rop_suexe;

{$MODE OBJFPC}
{$LONGSTRINGS ON}
{$RANGECHECKS ON}
{$SMARTLINK ON}
{$ASMMODE INTEL}
{$CODEPAGE UTF8}

{
    Program for set file owner to root:root.
    For GNU/Linux 64 bit version. Root priveleges needed.
    Version: 2.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2021  Artyomov Alexander
    http://self-made-free.ru/ (Ex http://aralni.narod.ru/)
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

uses SysUtils, BaseUnix, Unix;

var
    fn : utf8string;
    f  : Int64;

begin

for f := 1 to ParamCount do begin

fn := ParamStr(f);
WriteLn(fn);
fn := ExpandFileName(fn);
WriteLn(fn);
if fpChown(fn,0,0) <> 0 then WriteLn('Error') else WriteLn('Now root:root');

if FpChmod(fn, S_ISUID or S_IRUSR or S_IWUSR or S_IXUSR or S_IXGRP or S_IXOTH or S_IRGRP or S_IROTH) <> 0 then WriteLn('Error') else WriteLn('Now chmod');

{
S_ISUID Set user ID on execution.
S_ISGID Set Group ID on execution.
S_ISVTX Set sticky bit.
S_IRUSR Read by owner.
S_IWUSR Write by owner.
S_IXUSR Execute by owner.
S_IRGRP Read by group.
S_IWGRP Write by group.
S_IXGRP Execute by group.
S_IROTH Read by others.
S_IWOTH Write by others.
S_IXOTH Execute by others.
S_IRWXO Read, write, execute by others.
S_IRWXG Read, write, execute by groups.
S_IRWXU Read, write, execute by user. 
}

fpSystem('stat -c%A\ %a\ %U\:%G ' + fn);

end;

end.