// Clock.
// For GNU/Linux.
// Version: 1.
// Copyright (C) 2024-2025 Artyomov Alexander
// http://self-made-free.ru/
// aralni@mail.ru

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.

// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#include <gtk/gtk.h>
#include <time.h>

time_t t;
struct tm tm;

	GtkWidget *label;

int isleap(int year)
{
  return (!(year&3) && ((year%100) || !(year%400)));
}

int withday(int m)
{
switch (m)
{
case 0:
case 2:
case 4:
case 6:
case 7:
case 9:
case 11:
{
return 1;
break;
}
case 1:
{
if (isleap(tm.tm_year)) {return 1;} else {return 0;};
break;
}
}
return 0;
}

static gboolean
tick(gpointer data)
{
t = time (NULL);
localtime_r (& t, & tm);
char str[255];

strftime (str, 254, "<span foreground=\"black\" font_size=\"175pt\" font_weight=\"bold\">%H:%M:%S</span>\n<span foreground=\"blue\" font_size=\"135pt\" font_weight=\"bold\">%a %d %b\n%m)</span><span foreground=\"red\" font_size=\"135pt\" font_weight=\"bold\">  %Y?</span>", & tm);

unsigned long long int f;
for (f = 0; f < strlen(str); f++) {if (str[f]==')') {if (withday(tm.tm_mon))  {str[f]='+';} else {str[f]=' ';};  };  if (str[f] == '?') { if (isleap(tm.tm_year)) {str[f]='B';} else {str[f]=' ';}; break;}}

gtk_label_set_label(GTK_LABEL(label), str);
return 1;
}

static void
activate (GtkApplication *app,
          gpointer        user_data)
{
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *box;

window = gtk_application_window_new (app);
gtk_window_set_title (GTK_WINDOW (window), "Часы | Clock");
box = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
gtk_window_set_child (GTK_WINDOW (window), box);

label = gtk_label_new ("");
gtk_label_set_use_markup (GTK_LABEL (label),1);
gtk_box_append (GTK_BOX (box), label);
gtk_widget_set_visible (window, 1);
gtk_window_maximize(GTK_WINDOW(window));

g_timeout_add_seconds(1, tick, label);
}

int
main (int    argc,
      char **argv)
{
  GtkApplication *app;
  int status;
  app = gtk_application_new ("org.gtk.clock", G_APPLICATION_DEFAULT_FLAGS);
  g_signal_connect (app, "activate", G_CALLBACK (activate), NULL);
  status = g_application_run (G_APPLICATION (app), argc, argv);
  g_object_unref (app);

  return status;
}