#!/bin/bash

mkdir -p ./units/
fpc -O4 -XX -CX -Cg ver.pas
./obtainmse.sh
fpc -O4 -XX -CX -Cg msepatch.pas
./msepatch
     if [ "$?" != "0" ]
     then
          echo 'MSE patch error - update FAILED :('
          exit
     fi
find ./ \( -name "*_mfm.pas" \)  -delete
./ver
./compile_msetools.sh

fpc -B -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -Fu./ -FU./units/ -Fu./ -Fu./mseide-msegui/lib/common/* -Fu./mseide-msegui/lib/common/kernel/linux -CX -XX -O2 -Mobjfpc gorg64.pas
#fpc -B -Cg -k-pie -k-znow -CfSSE64 -Fu./ -FU./units/ -Fu./ -Fu./mseide-msegui/lib/common/* -Fu./mseide-msegui/lib/common/kernel/linux -CX -XX -gl -O2 -Mobjfpc gorg64.pas
mold -run gcc -flto -ffast-math -fforce-addr -funroll-loops -O4 -msse4a -fPIE -pie gorg64_spktone.c  -o gorg64_spktone -lm || fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O2 -Mobjfpc gorg64_spktone.pas
#mold -run gcc -flto -fPIE -pie -O4 -funroll-loops -msse4a -fforce-addr -falign-functions=4 -ffast-math `pkg-config --cflags gtk4` -o dclockpanel dclockpanel.c `pkg-config --libs gtk4` || fpc -Xs- -Ow -FWo.opt -OWAll -CfSSE64 -CX -XX -Cg -k-pie -k-znow -O2 dclockpanel.pas
#fasm gorg64_spkon.fasm && chmod =04755 gorg64_spkon
#fasm gorg64_spkoff.fasm && chmod =04755 gorg64_spkoff
#fasm gorg64_spkplay.fasm && chmod =04755 gorg64_spkplay

fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc chext.pas
fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc untar.pas
fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc wavrec.pas
fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc wavnorm.pas
fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc xsendenter.pas
fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc renice_tree.pas
fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc voicestarter.pas
fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O3 -Mobjfpc vc2.pas

#fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O4 -Mobjfpc gwm.pas

mold -run gcc -flto -ffast-math -fforce-addr -funroll-loops -O4 -msse4a -fPIE -pie gorg64_runner.c  -o gorg64_runner -lm || fpc -B -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O2 -Mobjfpc gorg64_runner.pas

as _true.S -o _true.o 
as _false.S -o _false.o 
#mold -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie _true.o  -o _true
#mold -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie _false.o  -o _false
# -fuse-ld=lld

ld.lld-19 -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie _true.o  -o _true
ld.lld-19 -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie _false.o  -o _false

as gorg64_spkon.S -o gorg64_spkon.o 
#mold -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie gorg64_spkon.o  -o gorg64_spkon
ld.lld-19 -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie gorg64_spkon.o  -o gorg64_spkon
rm gorg64_spkon.o || fpc -B -Cg -k-pie -k-znow -O2 -CX -XX gorg64_spkon.pas
as gorg64_spkoff.S -o gorg64_spkoff.o 
#mold -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie gorg64_spkoff.o  -o gorg64_spkoff 
ld.lld-19 -L /usr/lib/x86_64-linux-gnu -lc --no-dynamic-linker --pie gorg64_spkoff.o  -o gorg64_spkoff 
rm gorg64_spkoff.o || fpc -B -Cg -k-pie -k-znow -O2 -CX -XX gorg64_spkoff.pas
mold -run gcc -ffast-math -fforce-addr -funroll-loops -O4 -msse4a -fPIE -pie gorg64_spkplay.c  -o gorg64_spkplay -lm || fpc -Xs- -Ow -FWo.opt -OWAll -Cg -k-pie -k-znow -CfSSE64 -CX -XX -O2 -Mobjfpc gorg64_spkplay.pas

pushd sortucs4-src
make clean
make
mv sortucs4 ../
make clean
popd

pushd todo-src
make clean
make
mv todo ../
make clean
popd

pushd dclockspec4
make clean
make
mv dclockpanel termometeropenweathermap termometerwttr ../
make clean
popd
