# sortucs4 - UTF-8 Text and Table Sorter

## Description
`sortucs4` is a command-line utility for sorting text files and tables with full UTF-8 support. It can handle both plain text files and tabular data with customizable delimiters.

## Features
- Unicode-aware sorting (UCS-4 based)
- Support for multibyte UTF-8 characters
- Tabular data processing
- In-place file modification
- Custom column delimiters

## Installation
Compile from source using Free Pascal Compiler:
```bash
fpc sortucs4.pas

Usage

sortucs4 <file> [<column> [<delimiter>]]

Examples:
bash

# Sort text file
./sortucs4 textfile.txt

# Sort table by 2nd column
./sortucs4 data.tsv 2

# Sort CSV by 3rd column
./sortucs4 data.csv 3 ','

License

AGPLv3+: GNU Affero General Public License version 3 or later.
Author

Alexander Artyomov with AI-assisted code generation (DeepSeek Chat).


### 4. Лицензия (COPYING)
Рекомендую поместить полный текст AGPLv3 в файл COPYING. Вы можете скачать его с:
https://www.gnu.org/licenses/agpl-3.0.txt

Для сборки man-страниц из формата ronn можно использовать утилиту `ronn`:
```bash
ronn --roff sortucs4.1.ru.ronn
ronn --roff sortucs4.1.en.ronn