program test_string4;

uses
  string4unit, SysUtils;
// Ok
var
  S1, S2, S3: string4;
begin
  // Создание строк
  S1 := string4.Create;
  S2 := string4.Create;
  S1.FromUTF8('Привет, ');
  S2.FromUTF8('мир!');

  // Конкатенация
  S3 := S1.Concat(S2);
  WriteLn(S3.ToUTF8); // Вывод: Привет, мир!

  // Поддержка RTL текста
  S3.FromUTF8('שלום'); // Иврит (RTL)
  if S3.IsRTL then
    S3.Reverse; // Реверс строки
  WriteLn(S3.ToUTF8); // Вывод: םולש

  // Очистка и резервирование памяти
  S3.Clear;
  S3.Reserve(100);
  S3.FromUTF8('Новая строка');
  WriteLn(S3.ToUTF8); // Вывод: Новая строка

  // Освобождение памяти
  S1.Free;
  S2.Free;
  S3.Free;
end.