program test_ucs4op;

{$MODE OBJFPC}{$H+}
{$RANGECHECKS ON}
{$CODEPAGE UTF8}

uses
  ucs4unit, ucs4opunit, SysUtils;

var
  S1, S2, S3, P1, P2, P3: ucs4;
  I: Integer;
begin
  // Инициализация
  S1.Init;
  S2.Init;
  S3.Init;

  try
    // Тест создания строк
    WriteLn('=== Basic Tests ===');
    S1.FromUTF8('Привет, ');
    S2.FromUTF8('мир!');
    WriteLn('S1: ', S1.ToUTF8); // Привет,
    WriteLn('S2: ', S2.ToUTF8); // мир!

    // Тест конкатенации
    S3 := S1.Concat(S2);
    WriteLn('Concat: ', S3.ToUTF8); // Привет, мир!

    // Тест доступа к символам
    WriteLn('Chars[0]: $', HexStr(S1.Chars[0], 8)); // Код первого символа
    WriteLn('Length: ', S1.Length); // Длина строки

    // Тест RTL текста
    WriteLn(LineEnding + '=== RTL Test ===');
    S3.FromUTF8('עברית');
    WriteLn('Original: ', S3.ToUTF8);
    if S3.IsRTL then
    begin
      S3.Reverse;
      WriteLn('Reversed: ', S3.ToUTF8);
    end;

    // Тест производительности
    WriteLn(LineEnding + '=== Performance Test ===');
    S1.Clear;
    S2.Clear;
    S3.Clear;

    // Заполнение большой строки
    Write('Creating large string... ');
    S2.FromUTF8('test ');
    for I := 1 to 10000 do
    begin
      S3 := S1.Concat(S2); // Используем S3 как временную переменную
      S1 := S3;
    end;
    WriteLn('Length: ', S1.Length);

    // Тест реверса
    Write('Reversing... ');
    S1.Reverse;
    WriteLn('Done');

P1.Init;P2.Init;P3.Init;
P1:='Привет'; P2 := ' мир!';
P3 := P1+P2;
WriteLn(P3.ToUTF8);
S3.Clear;
S3 := 'Пока';
WriteLn(S3.ToUTF8, S3.Length);
if S3 = 'Пока' then WriteLn('>>>>');
    // Очистка
    Write('Clearing... ');
//    S1.Clear;
    WriteLn('Done');

  finally
    // Освобождение ресурсов (только для основных переменных)
//    S1.Clear;
    S2.Clear;
    S3.Clear;
  end;

  WriteLn(LineEnding + 'All tests completed successfully.');
end.