{ This unit provides a low-level interface to the Linux clone system call }
unit syscloneunit;

{$mode objfpc}{$H+}
{$ASMMODE INTEL}

interface

uses
  BaseUnix;

type
  TThreadFunction = function: PtrInt; cdecl;

function SysClone(Func: TThreadFunction): LongInt;

implementation

const
  CLONE_VM      = $00000100;
  CLONE_FS      = $00000200;
  CLONE_FILES   = $00000400;
  CLONE_SIGHAND = $00000800;
  CLONE_PARENT  = $00008000;
  CLONE_THREAD  = $00010000;
  CLONE_IO      = $80000000;
  THREAD_FLAGS  = CLONE_VM or CLONE_FS or CLONE_FILES or CLONE_SIGHAND or CLONE_PARENT or CLONE_THREAD or CLONE_IO;
  STACK_SIZE    = 4096 * 1024;
  SYS_clone     = 56;
  SYS_mmap      = 9;
  SYS_exit      = 60;

function mmap(addr: Pointer; length, prot, flags, fd: LongInt; offset: Int64): Pointer; cdecl; external 'c' name 'mmap';

function AllocateStack: Pointer; assembler; nostackframe;
asm
  xor rdi, rdi
  mov rsi, STACK_SIZE
  mov rdx, 3  { PROT_READ | PROT_WRITE }
  mov r10, 34 { MAP_ANONYMOUS | MAP_PRIVATE }
  mov r8, -1
  xor r9, r9
  mov rax, SYS_mmap
  syscall
  cmp rax, -1
  jne @done
  xor rax, rax
@done:
end;

function SysClone(Func: TThreadFunction): LongInt; assembler; nostackframe;
asm
  call AllocateStack
  test rax, rax
  jz @error

  mov rdi, Func    { Передаём функцию явно }
  lea rsi, [rax + STACK_SIZE - 16] { Выровнять стек }
  mov [rsi], rdi  { Сохранить Func в стек перед вызовом clone }

  mov rdi, THREAD_FLAGS
  mov rax, SYS_clone
  syscall
  test rax, rax
  js @error
  jz @child
  ret

@child:
  mov rdi, [rsp]  { Извлекаем Func из стека }
  and rsp, -16    { Выровнять стек перед вызовом }
  call rdi        { Вызываем функцию }
  mov rdi, rax    { Передаём код возврата в exit }
  mov rax, SYS_exit
  syscall

@error:
  hlt  { Остановка в случае ошибки }
  ret
end;

end.