unit wmtest;

{
    Running WM test unit.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025  Artyomov Alexander
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

interface

uses
  x, xlib, xutil, xatom, sysutils, ctypes;

var
  display: PDisplay;
  root: TWindow;
  wm_running: Boolean = False;

implementation

procedure check_wm_running;
var
  wm_check_atom: TAtom;
  wm_check_win: TWindow;
  actual_type: TAtom;
  actual_format: cint;
  nitems, bytes_after: culong;
  data: PWindow;
begin
  wm_check_atom := XInternAtom(display, '_NET_SUPPORTING_WM_CHECK', True);
  if wm_check_atom = None then Exit;

  if XGetWindowProperty(display, root, wm_check_atom, 0, 1, False, XA_WINDOW,
                        @actual_type, @actual_format, @nitems, @bytes_after, @data) = Success then
  begin
    if data <> nil then
    begin
      wm_running := True;
      XFree(data);
    end;
  end;
end;

begin
  display := XOpenDisplay(nil);
  if display = nil then
  begin
    Writeln('Не удалось открыть дисплей');
    Halt(1);
  end;

  root := DefaultRootWindow(display);

  check_wm_running;
  if wm_running then
  begin
    Writeln('Другой оконный менеджер уже запущен');
//    XCloseDisplay(display);
//    Halt(1);
  end;

  XCloseDisplay(display);
end.