{%MainUnit fpwmmanager.pas}

{procedure TFPWMClient.activate();
begin
  active();
end;

procedure TFPWMClient.deactivate();
begin
  setactive(0);
end;}

function TFPWMClient.hasWindow(w: TWindow): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[FPWMClient.hasWindow]');
  {$endif}
  Result := (m_window = w) or (m_border.hasWindow(w));
end;

function TFPWMClient.revertTo(): TFPWMClient;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.revertTo]');
  {$endif}
  Result := m_revert;
end;

procedure TFPWMClient.setRevertTo(c: TFPWMClient);
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.setRevertTo]');
  {$endif}
  m_revert := c;
end;

function TFPWMClient.isHidden(): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.isHidden]');
  {$endif}
  Result := m_state = IconicState;
end;

function TFPWMClient.isWithdrawn(): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.isWithdrawn]');
  {$endif}
  Result := m_state = WithdrawnState;
end;

function TFPWMClient.isNormal(): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.isNormal]');
  {$endif}
  Result := m_state = NormalState;
end;

function TFPWMClient.isTransient(): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.isTransient]');
  {$endif}
  Result := m_transient <> None;
end;

function TFPWMClient.transientFor(): TWindow;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.transientFor]');
  {$endif}
  Result := m_transient;
end;

function TFPWMClient.isFixedSize(): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.isFixedSize]');
  {$endif}
  Result := m_fixedSize;
end;

function TFPWMClient.GetLabel(): string;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.GetLabel]');
  {$endif}
  Result := m_label;
end;

function TFPWMClient.name(): string;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.name]');
  {$endif}
  Result := m_name;
end;

function TFPWMClient.iconName(): string;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.iconName]');
  {$endif}
  Result := m_iconName;
end;

procedure TFPWMClient.fatal(m: string);
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.fatal]');
  {$endif}
  m_windowManager.fatal(m);
end;

function TFPWMClient.display(): PDisplay;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.display]');
  {$endif}
  Result := m_windowManager.display();
end;

function TFPWMClient.parent(): TWindow;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.parent]');
  {$endif}
  Result := m_border.parent();
end;

function TFPWMClient.root(): TWindow;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.root]');
  {$endif}
  Result := m_windowManager.root();
end;

function TFPWMClient.activeClient(): TFPWMClient;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.activeClient]');
  {$endif}
  Result := m_windowManager.activeClient();
end;

function TFPWMClient.isActive(): Boolean;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.isActive]');
  {$endif}
  Result := activeClient() = Self;
end;

function TFPWMClient.windowManager(): TFPWMWindowManager;
begin
  {$ifdef FPWM_TRACE_INLINES}
  FPWMTrace('[TFPWMClient.windowManager]');
  {$endif}
  Result := m_windowManager;
end;

