{ ************************************************************************ 
  Header file for the `xvertext' routines.
   Copyright (c) 1992 Alan Richardson (mppa3@uk.ac.sussex.syma)
  ************************************************************************ }
unit fpwmrotated;

{$mode objfpc}
{$H+}

interface

{$include fpwmdefines.inc}

uses
  // RTL, FCL
  SysUtils,
  // UNIX
  ctypes, x, xlib, xutil, baseunix, unix,
  // fpwm
  fpwmgeneral
  ;
{
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdlib.h>
#include <string.h>}

const
  TLEFT = 	 	 1;
  TCENTRE =	 	 2;
  TRIGHT =      	 3;
  MLEFT =	         4;
  MCENTRE =	 	 5;
  MRIGHT =	 	 6;
  BLEFT =	         7;
  BCENTRE =	 	 8;
  BRIGHT = 	 	 9;

  XV_NOFONT =	         1;  { no such font on X server }
  XV_NOMEM =	         2;  { couldn't do malloc }
  XV_NOXIMAGE =     	 3;  { couldn't create an XImage }

const
   XV_VERSION     = 2.0;
  XV_COPYRIGHT  =  'xvertext routines Copyright (c) 1992 Alan Richardson';

var
  xv_errno: Integer;


{* *** The font structures *** *}

type
  TBitmapStruct=record
    bit_w: Integer;
    bit_h: Integer;

    bm: x.TPixmap;
  end;
  PBitmapStruct = ^TBitmapStruct;

  TXCharStruct=record
    ascent: Integer;
    descent: Integer;
    lbearing: Integer;
    rbearing: Integer;
    width: Integer;

    glyph: TBitmapStruct;
  end;
  PXCharStruct = ^TXCharStruct;

  TXRotFontStruct=record
    dir:            Integer;
    height:         Integer;
    max_ascent:     Integer;
    max_descent:    Integer;
    max_char:       Integer;
    min_char:       Integer;
    name_:       string;

    xfontstruct:    PXFontStruct;

    per_char: array[0..94] of TXCharStruct; // [95];
  end;
  PXRotFontStruct = ^TXRotFontStruct;


{* ---------------------------------------------------------------------- *}
{* ---------------------------------------------------------------------- *}


//extern int		 xv_errno;

function  XRotLoadFont(dpy: PDisplay; fontname: string; angle: Real): PXRotFontStruct;

function XRotVersion(var str: string): real;
procedure XRotUnloadFont (dpy: PDisplay; rotfont: PXRotFontStruct);
function XRotTextWidth(rotfont: PXRotFontStruct; var str: string; len: Integer): Integer;
procedure XRotDrawString(dpy: PDisplay; rotfont: PXRotFontStruct; drawable: x.TDrawable;
		    gc: xlib.TGC; x, y: Integer; var str: string; len: Integer);
procedure XRotDrawAlignedString(dpy: PDisplay; rotfont: PXRotFontStruct;
			   drawable: x.TDrawable; gc: xlib.TGC; x, y: Integer;
			   var text: string; align: Integer);


{* ---------------------------------------------------------------------- *}
 

//#else

//extern int		 xv_errno;

implementation

{* ********************************************************************** */

/* xvertext, Copyright (c) 1992 Alan Richardson (mppa3@uk.ac.sussex.syma)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  All work developed as a consequence of the use of
 * this program should duly acknowledge such use. No representations are
 * made about the suitability of this software for any purpose.  It is
 * provided "as is" without express or implied warranty.
 */

/* ********************************************************************** */



/* ---------------------------------------------------------------------- *}


{
static char *my_strdup(char *);
static char *my_strtok(char *, char *);
}

{* ---------------------------------------------------------------------- */


/* *** Routine to mimic `strdup()' (some machines don't have it) *** *}

//static char *my_strdup(char *str)
// function my_strdup(var str: string): String; <<-- Useless, in Pascal we can just assign the string

//* ---------------------------------------------------------------------- */


{* *** Routine to replace `strtok' : this one returns a zero
       length string if it encounters two consecutive delimiters *** *}

(*function my_strtok(var str1, str2: string): string;
var
   ret: string;
   i: Integer;
   j: Integer;
   stop: Integer;
   {
   static int start, len;
   static char *stext;
   }
   {
   start: Integer;
   len: Integer;
   stext: string;
   }
begin

  //* this error should never occur ... */
  if (str2 = nil) then begin
    writeln(stderr,
	    'Fatal error: my_strtok(): recieved null delimiter string');
    exit(1);
  end;

  //* initialise if str1 not NULL ... */
  if (str1 <> nil) then begin
    start := 0;
    stext := str1;
    len := length(str1);
  end;

  //* run out of tokens ? ... */
  if (start >= len) then return:= nil;

  //* loop through characters ... */
  for i := start to len-1 do begin
    //* loop through delimiters ... */
    stop := 0;
    for j:= 0 to lenght(str2) - 1 do
      if (stext[i] = str2[j]) then stop := 1;
 
    if (stop) then break;
  end;

  stext[i] := '\0';
  ret := stext + start;
  start := i+1;

  return := ret;
end;*)


//Function To Get Characters From The String
{function StrMid(const sData: string; nStart: integer): string; overload;
begin
 Result := copy(sData, nStart, Length(sData) - (nStart - 1));
end;}

var
  TokS: string;

//String Tokenizer function
function my_strtok(S: string; Tok: string = ''): string;
var
  i, LenTok: integer;
begin
 if not(S = '') then // NewString
 begin
   TokS := S;
   result := '';
   Exit;
 end;

 if Tok = '' then //If No Token
 begin
   result := TokS;
   Exit;
 end;

 LenTok := Length(Tok);

 for i := 0 to Length(TokS) - LenTok do
 begin
   if Copy(TokS, i, LenTok) = Tok then //If Token Found
   begin
     result := Copy(TokS, 1, i - LenTok);
     TokS := Copy(TokS, i + LenTok + 1, Length(TokS) - (i + LenTok));
     Exit;
   end;
 end;
 //If Program Reaches Here, Return The Rest Of The String
 result := TokS;
 TokS := '';
end;


//* ---------------------------------------------------------------------- */
  

//* *** Routine to return version/copyright information *** */

function XRotVersion(var str: string): real;
begin
  Str := XV_COPYRIGHT;
  Result := XV_VERSION;
end;


//* ---------------------------------------------------------------------- */


//* *** Load the rotated version of a given font *** */

function  XRotLoadFont(dpy: PDisplay; fontname: string; angle: Real): PXRotFontStruct;
var
   val: Byte;
   I1: PXImage = nil;
   I2: PXImage = nil;
   canvas: x.TPixmap;
   root: TWindow;
   screen: Integer;
   font_gc: TGC;
   text: string [3];//c/*, errstr[300];*/
   fontstruct: PXFontStruct;
   rotfont: PXRotFontStruct;
   ichar, i, j, index, dir: Integer;
   boxlen: cint = 60;
   vert_w, vert_h, vert_len, bit_w, bit_h, bit_len: Integer;
   min_char, max_char: Integer;

   //unsigned char *vertdata, *bitdata;
   vertdata, bitdata: PByte;
   ascent, descent, lbearing, rbearing: Integer;
   on_: cint = 1;
   off: cint = 0;
begin
  {$ifdef FPWM_TRACE}
  FPWMTrace(Format('XRotLoadFont BEGIN fontname=%s', [fontname]));
  {$endif}

  //* make angle positive ... */
  if (angle < 0) then while (angle<0) do angle := angle+360;

  //* get nearest vertical or horizontal direction ... */
  dir := Round((angle+45.0)/90.0) mod 4;

  //* useful macros ... */
  screen := DefaultScreen(dpy);
  root := DefaultRootWindow(dpy);

  //* create the depth 1 canvas bitmap ... */
  canvas := XCreatePixmap(dpy, root, boxlen, boxlen, 1);
 
  //* create a GC ... */
  font_gc := XCreateGC(dpy, canvas, 0, nil);
  XSetBackground(dpy, font_gc, off);

  //* load the font ... */
  fontstruct := XLoadQueryFont(dpy, PChar(fontname));
  if (fontstruct = nil) then begin
    xv_errno := XV_NOFONT;
    Exit(nil);
  end;
 
  XSetFont(dpy, font_gc, fontstruct^.fid);

  //* allocate space for rotated font ... */
  //rotfont := (XRotFontStruct *)malloc((unsigned)sizeof(XRotFontStruct));
  rotfont := PXRotFontStruct(GetMem(sizeof(TXRotFontStruct)));
  if (rotfont = nil) then begin
    xv_errno := XV_NOMEM;
    Exit(nil);
  end;
   
  //* determine which characters are defined in font ... */
  min_char := fontstruct^.min_char_or_byte2;
  max_char := fontstruct^.max_char_or_byte2;
 
  //* we only want printing characters ... */
  if (min_char<32) then min_char := 32;
  if (max_char>126) then max_char := 126;
     
  //* some overall font data ... */
  rotfont^.name_ := fontname;
  rotfont^.dir := dir;
  rotfont^.min_char := min_char;
  rotfont^.max_char := max_char;
  rotfont^.max_ascent := fontstruct^.max_bounds.ascent;
  rotfont^.max_descent := fontstruct^.max_bounds.descent;
  rotfont^.height := rotfont^.max_ascent+rotfont^.max_descent;

  {$ifdef FPWM_TRACE}
  FPWMTrace('XRotLoadFont MID');
  {$endif}

  //* remember xfontstruct for `normal' text ... */
  if (dir = 0) then
    rotfont^.xfontstruct := fontstruct
  else
  begin
    //* font needs rotation ... */
    //* loop through each character ... */
    for ichar := min_char to max_char do
    begin
      index := ichar-fontstruct^.min_char_or_byte2;
 
      //* per char dimensions ... */
      ascent := fontstruct^.per_char[index].ascent;
      rotfont^.per_char[ichar-32].ascent := ascent;

      descent := fontstruct^.per_char[index].descent;
      rotfont^.per_char[ichar-32].descent := descent;

      lbearing := fontstruct^.per_char[index].lbearing;
      rotfont^.per_char[ichar-32].lbearing := lbearing;

      rbearing := fontstruct^.per_char[index].rbearing;
      rotfont^.per_char[ichar-32].rbearing := rbearing;

      rotfont^.per_char[ichar-32].width :=
        fontstruct^.per_char[index].width;

      //* some space chars have zero body, but a bitmap can't have ... */
      if (ascent = 0) and (descent = 0) then
      begin
	ascent := 1;
	rotfont^.per_char[ichar-32].ascent := 1;
      end;
      if (lbearing = 0) and (rbearing = 0) then
      begin
	rbearing := 1;
	rotfont^.per_char[ichar-32].rbearing := 1;
      end;

      //* glyph width and height when vertical ... */
      vert_w := rbearing-lbearing;
      vert_h := ascent+descent;

      //* width in bytes ... */
      vert_len := ((vert_w-1) div 8) + 1;
 
//      {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID2');{$endif}
      XSetForeground(dpy, font_gc, off);
      XFillRectangle(dpy, canvas, font_gc, 0, 0, boxlen, boxlen);

//      {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID3');{$endif}
      //* draw the character centre top right on canvas ... */
      text := Format('%c', [ichar]);
      XSetForeground(dpy, font_gc, on_);
      XDrawImageString(dpy, canvas, font_gc, boxlen div 2 - lbearing,
		       boxlen div 2 - descent, PChar(String(text)), 1);

      //* reserve memory for first XImage ... */
      // vertdata := (unsigned char *) malloc((unsigned)(vert_len*vert_h));
      vertdata := PByte(GetMem(vert_len*vert_h));
      if (vertdata = nil) then begin
	xv_errno := XV_NOMEM;
	Exit(nil);
      end;
  
      //* create the XImage ... */
      I1 := XCreateImage(dpy, DefaultVisual(dpy, screen), 1, XYBitmap,
			0, PChar(vertdata), vert_w, vert_h, 8, 0);

      if (I1 = nil) then begin
	xv_errno := XV_NOXIMAGE;
	Exit(nil);
      end;
  
      I1^.byte_order := MSBFirst;
      I1^.bitmap_bit_order := MSBFirst;
   
      //* extract character from canvas ... */
      XGetSubImage(dpy, canvas, boxlen div 2, boxlen div 2-vert_h,
		   vert_w, vert_h, 1, XYPixmap, I1, 0, 0);
      I1^.format := XYBitmap;
 
      //* width, height of rotated character ... */
      if (dir = 2) then begin
	bit_w := vert_w;
	bit_h := vert_h;
      end
      else begin
	bit_w := vert_h;
	bit_h := vert_w;
      end;

      //* width in bytes ... */
      bit_len := ((bit_w-1) div 8) + 1;

      rotfont^.per_char[ichar-32].glyph.bit_w := bit_w;
      rotfont^.per_char[ichar-32].glyph.bit_h := bit_h;

      //* reserve memory for the rotated image ... */
      bitdata := PByte(GetMem(bit_h*bit_len));

      if (bitdata = nil) then begin
	xv_errno := XV_NOMEM;
	Exit(nil);
      end;

      //* create the image ... */
//      {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID4');{$endif}
      I2 := XCreateImage(dpy, DefaultVisual(dpy, screen), 1, XYBitmap, 0,
			PChar(bitdata), bit_w, bit_h, 8, 0);
 
      if (I2 = nil) then
      begin
	xv_errno := XV_NOXIMAGE;
	Exit(nil);
      end;

      I2^.byte_order := MSBFirst;
      I2^.bitmap_bit_order := MSBFirst;
 
      //* map vertical data to rotated character ... */
      for j:=0 to bit_h-1 do begin
	for i:=0 to bit_w-1 do begin
	  //* map bits ... */
	  if (dir = 1) then
	    val := vertdata[i*vert_len + (vert_w-j-1) div 8] and
	      (128shr((vert_w-j-1) mod 8))
   
	  else if (dir = 2) then
	    val := vertdata[(vert_h-j-1)*vert_len + (vert_w-i-1) div 8] and
	      (128shr((vert_w-i-1) mod 8))
                    
	  else 
	    val := vertdata[(vert_h-i-1)*vert_len + j div 8] and
	      (128shr(j mod 8));
        
	  if (val <> 0) then
	    bitdata[j*bit_len + i div 8] := bitdata[j*bit_len + i div 8] or
	      (128shr(i mod 8));
	end;
      end;
   
      //* create this character's bitmap ... */
//      {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID5');{$endif}
      rotfont^.per_char[ichar-32].glyph.bm :=
	XCreatePixmap(dpy, root, bit_w, bit_h, 1);
     
//      {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID6');{$endif}
      //* put the image into the bitmap ... */
      XPutImage(dpy, rotfont^.per_char[ichar-32].glyph.bm,
		font_gc, I2, 0, 0, 0, 0, bit_w, bit_h);
  
      //* free the image and data ... */
//      {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID7 ' + IntToStr(Integer(I1)));{$endif}
//      XDestroyImage(I1);
//      XDestroyImage(I2);
      {c      free((char *)bitdata);  -- XDestroyImage does this
               free((char *)vertdata);*}
    end;

//    {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID8');{$endif}
    XFreeFont(dpy, fontstruct);
  end;

  {$ifdef FPWM_TRACE}FPWMTrace('XRotLoadFont MID8');{$endif}
  //* free pixmap and GC ... */
  XFreePixmap(dpy, canvas);
  XFreeGC(dpy, font_gc);

  Result := rotfont;

  {$ifdef FPWM_TRACE}
  FPWMTrace('XRotLoadFont END');
  {$endif}
end;


//* ---------------------------------------------------------------------- */


//* *** Free the resources associated with a rotated font *** */

procedure XRotUnloadFont(dpy: PDisplay; rotfont: PXRotFontStruct);
var
   ichar: Integer;
begin
  if (rotfont^.dir = 0) then
    XFreeFont(dpy, rotfont^.xfontstruct)
  else
  begin
    //* loop through each character, freeing its pixmap ... */
    for ichar:= rotfont^.min_char-32 to rotfont^.max_char-32 do
      XFreePixmap(dpy, rotfont^.per_char[ichar].glyph.bm);
  end;
  //* rotfont should never be referenced again ... */
//  free((char *)rotfont^.name);
  FreeMem(rotfont);
end;


//* ---------------------------------------------------------------------- */
   

//* *** Return the width of a string *** */

function XRotTextWidth(rotfont: PXRotFontStruct; var str: string; len: Integer): Integer;
var
   i, ichar, width: Integer;
begin
  width := 0;

  if (str = '') then Exit(0);

  if (rotfont^.dir = 0) then
    width := XTextWidth(rotfont^.xfontstruct, PChar(str), length(str))
  else
    for i:=1 to len do
    begin
      ichar := Byte(str[i])-32;
  
      { make sure it's a printing character ... }
      if (ichar >= 0) and (ichar<95) then
	width := width + rotfont^.per_char[ichar].width;
    end;

  Result := width;
end;


//* ---------------------------------------------------------------------- */


//* *** A front end to XRotPaintString : mimics XDrawString *** */

procedure XRotDrawString(dpy: PDisplay; rotfont: PXRotFontStruct; drawable: TDrawable;
    gc: xlib.TGC; x, y: Integer; var str: string; len: Integer);
var
  my_gc: xlib.TGC = nil;
  i, xp, yp, dir, ichar: Integer;
begin
  if (str = '') or (len<1) then exit();

  dir := rotfont^.dir;
  if (my_gc = nil) then my_gc := XCreateGC(dpy, drawable, 0, nil);

  XCopyGC(dpy, gc, GCForeground or GCBackground, my_gc);

  //* a horizontal string is easy ... */
  if (dir = 0) then
  begin
    XSetFillStyle(dpy, my_gc, FillSolid);
    XSetFont(dpy, my_gc, rotfont^.xfontstruct^.fid);
    XDrawString(dpy, drawable, my_gc, x, y, PChar(str), len);
    Exit;
  end;

  //* vertical or upside down ... */

  XSetFillStyle(dpy, my_gc, FillStippled);

  //* loop through each character in string ... */
  for i:= 1 to len do
  begin
    ichar := Byte(str[i])-32;

    //* make sure it's a printing character ... */
    if (ichar >= 0) and (ichar<95) then
    begin
      //* suitable offset ... */
      if (dir = 1) then begin
	xp := x-rotfont^.per_char[ichar].ascent;
	yp := y-rotfont^.per_char[ichar].rbearing;
      end
      else if (dir = 2) then begin
	xp := x-rotfont^.per_char[ichar].rbearing;
	yp := y-rotfont^.per_char[ichar].descent+1;
      end
      else begin
	xp := x-rotfont^.per_char[ichar].descent+1;
	yp := y+rotfont^.per_char[ichar].lbearing;
      end;
                   
      //* draw the glyph ... */
      XSetStipple(dpy, my_gc, rotfont^.per_char[ichar].glyph.bm);
    
      XSetTSOrigin(dpy, my_gc, xp, yp);
      
      XFillRectangle(dpy, drawable, my_gc, xp, yp,
		     rotfont^.per_char[ichar].glyph.bit_w,
		     rotfont^.per_char[ichar].glyph.bit_h);
    
      //* advance position ... */
      if (dir = 1) then
	y := y - rotfont^.per_char[ichar].width
      else if (dir = 2) then
	x := x - rotfont^.per_char[ichar].width
      else 
	y := y + rotfont^.per_char[ichar].width;
    end;
  end;
end;

  
    
//* ---------------------------------------------------------------------- */


//* *** A front end to XRotPaintAlignedString : uses XRotDrawString *** */

procedure XRotDrawAlignedString(dpy: PDisplay; rotfont: PXRotFontStruct;
   drawable: TDrawable; gc: xlib.TGC; x, y: Integer;
   var text: string; align: Integer);
var
  xp: Integer = 0;
  yp: Integer = 0;
  dir: Integer;
  i, this_width: Integer;
  nl: Integer = 1;
  max_width: Integer = 0;
  str1, str2, str3: string;
  tmp: Integer;
begin
  str1 := LineEnding;
  str2 := LineEnding;

  if (text = '') then Exit();
  
  dir := rotfont^.dir;

  //* count number of sections in string ... */
  for i:= 0 to length(text)-1 do
    if (text[i] = LineEnding) then
      nl := nl + 1;

  //* find width of longest section ... */
  str1 := text;
  str3 := my_strtok(str1, str2);
  max_width := XRotTextWidth(rotfont, str3, length(str3));

  repeat
    str3 := my_strtok('', str2);
    if (str3 <> '') then
      if (XRotTextWidth(rotfont, str3, length(str3))>max_width) then
	max_width := XRotTextWidth(rotfont, str3, length(str3));
  until ( str3 = '');

  {* calculate vertical starting point according to alignment policy and
     rotation angle ... *}
  if (dir = 0) then
  begin
    if (align = TLEFT) or (align = TCENTRE) or (align = TRIGHT) then
      yp := y+rotfont^.max_ascent
    else if (align = BLEFT) or (align = BCENTRE) or (align = BRIGHT) then
      yp := y-(nl-1)*rotfont^.height - rotfont^.max_descent
    else
    begin
      if (nl mod 2 = 0) then tmp := rotfont^.height div 2
      else tmp := 0;
      yp := y-(nl-1) div 2*rotfont^.height + rotfont^.max_ascent -
        rotfont^.height div 2 - tmp;
    end;
  end
  else if (dir = 1) then
  begin
    if (align = TLEFT) or (align = TCENTRE) or (align = TRIGHT) then
      xp := x+rotfont^.max_ascent
    else if (align = BLEFT) or (align = BCENTRE) or (align = BRIGHT) then
      xp := x-(nl-1)*rotfont^.height - rotfont^.max_descent
    else
    begin
      if (nl mod 2 = 0) then tmp := rotfont^.height div 2
      else tmp := 0;
      xp := x-(nl-1) div 2*rotfont^.height + rotfont^.max_ascent -
        rotfont^.height div 2 - tmp;
    end;
  end
  else if (dir = 2) then
  begin
    if (align = TLEFT) or (align = TCENTRE) or (align = TRIGHT) then
      yp := y-rotfont^.max_ascent
    else if (align = BLEFT) or (align = BCENTRE) or (align = BRIGHT) then
      yp := y+(nl-1)*rotfont^.height + rotfont^.max_descent
    else
    begin
      if (nl mod 2 = 0) then tmp := rotfont^.height div 2
      else tmp := 0;
      yp := y+(nl-1) div 2*rotfont^.height - rotfont^.max_ascent +
	rotfont^.height div 2 + tmp;
    end;
  end
  else
  begin
    if (align = TLEFT) or (align = TCENTRE) or (align = TRIGHT) then
      xp := x-rotfont^.max_ascent
    else if (align = BLEFT) or (align = BCENTRE) or (align = BRIGHT) then
      xp := x+(nl-1)*rotfont^.height + rotfont^.max_descent
    else
    begin
      if (nl mod 2 = 0) then tmp := rotfont^.height div 2
      else tmp := 0;
      xp := x+(nl-1) div 2*rotfont^.height - rotfont^.max_ascent +
	rotfont^.height div 2 + tmp;
    end;
  end;

  //free(str1);
  str1 := text;
  str3 := my_strtok(str1, str2);
  
  //* loop through each section in the string ... */
  while (str3 <> '') do
  begin
    //* width of this section ... */
    this_width := XRotTextWidth(rotfont, str3, length(str3));

    //* horizontal alignment ... */
    if (dir = 0) then
    begin
      if (align = TLEFT) or (align = MLEFT) or (align = BLEFT) then
	xp := x
      else if (align = TCENTRE) or (align = MCENTRE) or (align = BCENTRE) then
	xp := x-this_width div 2
      else
	xp := x-max_width;
    end
    else if (dir = 1) then
    begin
      if (align = TLEFT) or (align = MLEFT) or (align = BLEFT) then
	yp := y
      else if (align = TCENTRE) or (align = MCENTRE) or (align = BCENTRE) then
	yp := y+this_width div 2
      else
	yp := y+max_width;
    end

    else if (dir = 2) then
    begin
      if (align = TLEFT) or (align = MLEFT) or (align = BLEFT) then
	xp := x
      else if (align = TCENTRE) or (align = MCENTRE) or (align = BCENTRE) then
	xp := x+this_width div 2
      else
	xp := x+max_width;
    end
    else
    begin
      if (align = TLEFT) or (align = MLEFT) or (align = BLEFT) then
	yp := y
      else if (align = TCENTRE) or (align = MCENTRE) or (align = BCENTRE) then
	yp := y-this_width div 2
      else
	yp := y-max_width;
    end;

    //* draw the section ... */
    XRotDrawString(dpy, rotfont, drawable, gc, xp, yp,
		   str3, length(str3));

    str3 := my_strtok('', str2);

    //* advance position ... */
    if (dir = 0) then
      yp := yp + rotfont^.height
    else if (dir = 1) then
      xp := xp + rotfont^.height
    else if (dir = 2) then
      yp := yp - rotfont^.height
    else 
      xp := xp - rotfont^.height;
  end;

//  free(str1);
end;

end.
