unit glhkindex;

{$MODE OBJFPC}

interface

uses
 mkeysym;

const
MAX_GHK = 95;

type
TGhkIdx = 0..MAX_GHK;

const
ghk_names : array[TGhkIdx] of string = (
'Escape','F1','F2','F3','F4','F5','F6','F7','F8','F9','F10','F11','F12','PrintScreen','ScrollLock','Pause', // 15
'~','0','1','2','3','4','5','6','7','8','9','-','=','\','BackSpace', // 30
'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z', // 56
'[', ']', ';', 'Quote', ',', '.', '/', // 63
'Enter','Space','Tab','CapsLock', // 67
'Left','Right','Up','Down', // 71
'Insert','Delete','Home','End','PageUp','PageDown', // 77
'NumLock','NumPad0','NumPad1','NumPad2','NumPad3','NumPad4','NumPad5',
'NumPad6','NumPad7','NumPad8','NumPad9','NumDiv','NumMul','NumMinus','NumPlus','NumEnter','NumDot', // 94
'Menu' // 95
);

ghk_symb : array[TGhkIdx] of DWord = (
XK_Escape,XK_F1,XK_F2,XK_F3,XK_F4,XK_F5,XK_F6,XK_F7,XK_F8,XK_F9,XK_F10,XK_F11,XK_F12,XK_Print,XK_Scroll_Lock,XK_Pause, // 15
XK_asciitilde,XK_0,XK_1,XK_2,XK_3,XK_4,XK_5,XK_6,XK_7,XK_8,XK_9,XK_minus,XK_equal,XK_backslash,XK_BackSpace, // 30
XK_A,XK_B,XK_C,XK_D,XK_E,XK_F,XK_G,XK_H,XK_I,XK_J,XK_K,XK_L,XK_M,XK_N,XK_O,XK_P,XK_Q,XK_R,XK_S,XK_T,XK_U,XK_V,XK_W,XK_X,XK_Y,XK_Z, // 56
XK_bracketleft,XK_bracketright,XK_semicolon,XK_singlelowquotemark,XK_comma,XK_period,XK_slash, // 63
XK_Return,XK_space,XK_Tab,XK_Caps_Lock, // 67
XK_Left,XK_Right,XK_Up,XK_Down, // 71
XK_Insert,XK_Delete,XK_Home,XK_End,XK_Page_Up,XK_Page_Down, // 77
XK_Num_Lock,XK_KP_0,XK_KP_1,XK_KP_2,XK_KP_3,XK_KP_4,XK_KP_5,
XK_KP_6,XK_KP_7,XK_KP_8,XK_KP_9,XK_KP_Divide,XK_KP_Multiply,XK_KP_Subtract,XK_KP_Add,XK_KP_Enter,XK_KP_Separator, // 94
XK_Menu // 95
);

function StrToIdx(s:string):Int64;

implementation

function StrToIdx(s:string):Int64;
var d:DWord;
begin
for d := 0 to MAX_GHK do if s = ghk_names[d] then Exit(d);
Exit(-1);
end;

end.