program gorg64;

{
    GALAXY ORGANIZER
    For GNU/Linux.
    Version: 2.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2021-2025  Artyomov Alexander
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}
{$LONGSTRINGS ON}
{$RANGECHECKS ON}
{$SMARTLINK ON}
{$ASMMODE INTEL}
uses
{cmem,}cthreads,wmtest,
 msegui, msegraphics, msegraphutils, main, xlib
 ,unix,baseunix,linux,sysutils,urunu,x,mkeysym;
 
Procedure DoSig(sig : cint);cdecl;
begin
   writeln('Receiving signal: ',sig);
AppClose;
end; 

var
    oa,na : PSigActionRec;
 
begin

   new(na);
   new(oa);
   na^.sa_Handler:=SigActionHandler(@DoSig);
   fillchar(na^.Sa_Mask,sizeof(na^.sa_mask),#0);
   na^.Sa_Flags:=0;
   na^.Sa_Restorer:=Nil;
   if fpSigAction(SigTerm,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     AppClose;
     end;
   if fpSigAction(SigHup,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     AppClose;
     end;
   if fpSigAction(SigInt,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     AppClose;
     end;
   if fpSigAction(SigQuit,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     AppClose;
     end;
   if fpSigAction(SigTStp,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     AppClose;
     end;


{
fpSystem('icewm &');
fpSystem('icewmbg &');
}

//fpSystem('marco &');

//fpSystem('jwm &');

//fpSystem('openbox &');

//fpSystem('i3 &');

//fpSystem('fluxbox &');

// fpSystem('kwin &'); // hang

//fpSystem('twm &');

//fpSystem('wm2 &');

//fpSystem('wmx &');

//fpSystem('fpwm &');
//fpSystem('gorg64_runner fpwm');

//fpSystem('strace -f /usr/bin/gwm 2>&1 | tee > /tmp/log_strace.txt &');
//fpSystem('gorg64_runner /usr/bin/gwm');

//fpSystem('9wm &');

//fpSystem('dwm &');

//Sleep(4000);

 application.createform(tmainfo,mainfo);
 application.run;
end.