program gorg64_spkplay_alsa;

{$MODE OBJFPC}
{$RANGECHECKS ON}
{$LONGSTRINGS ON}
{$SMARTLINK ON}
{$ASMMODE INTEL}

{
    Program for playing melodys on PC-Speaker.
    For GNU/Linux 64 bit version.
    Version: 4.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2021,2022,2024  Artyomov Alexander
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

uses sysutils,unix,baseunix,linux,urun,alsa_sound;

const
	vol=10;

type
      TTW = packed record
       tone, duration : Word;
      end;
      PTW=^TTW;

var
    f, ff : Int64;
    oa,na : PSigActionRec;
    fs : Int64 = 0;
    a :  PTW = nil;
    fFileName : utf8string = '';

function spkf(tone : Word) : Word;
var
  tmp : Int64;
begin
if tone < 1 then Exit(0);
tmp := 1193182 div tone;
if tmp > $FFFF then tmp := $FFFF;
Exit(tmp);
end;
function spkf(tone : extended) : Word;
var
  tmp : Int64;
begin
if tone < 1 then Exit(0);
tmp := round(1193280 / tone);
if tmp > $FFFF then tmp := $FFFF;
Exit(tmp);
end;

function LoadFromFile(fn : utf8string) : boolean;
var
  fp : File of TTW;
begin
Assign(fp, fn);
FileMode := 0;
{$I-}
ReSet(fp);
{$I+} if IOResult <> 0 then Exit(true);
{$I-}
fs := FileSize(fp);
{$I+} if IOResult <> 0 then Exit(true);
GetMem(a, fs*SizeOf(TTW));
{$I-}
BlockRead(fp, a[0], fs);
{$I+} if IOResult <> 0 then Exit(true);
{$I-}
Close(fp);
{$I+} if IOResult <> 0 then Exit(true);
fFileName := fn;
Exit(false);
end;

Procedure DoSig(sig : cint);cdecl;
begin
 writeln('Receiving signal: ',sig);
 ALSAsilence(0, false);
 halt(0);
end;

begin
WriteLn('GALAXY ORGANIZER SPEAKER PLAYER Version 3');
WriteLn('Artyomov Alexander 2022-2024  License: GNU AGPLv3 and above');
WriteLn('Use: gorg64_spkplay_alsa or gorg64_spkplay_alsa somemusic.speaker somemusic2.speaker ...');

   new(na);
   new(oa);
   na^.sa_Handler:=SigActionHandler(@DoSig);
   fillchar(na^.Sa_Mask,sizeof(na^.sa_mask),#0);
   na^.Sa_Flags:= SA_RESTART;
   na^.Sa_Restorer:=Nil;
   if fpSigAction(SigTerm,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     halt(1);
     end;
   if fpSigAction(SigHup,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     halt(1);
     end;
   if fpSigAction(SigInt,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     halt(1);
     end;
   if fpSigAction(SigQuit,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     halt(1);
     end;
   if fpSigAction(SigTStp,na,oa)<>0 then
     begin
     writeln('Error: ',fpgeterrno,'.');
     halt(1);
     end;

fpSystem('renice -n -20 -p ' + inttostr(fpgetpid));

if ParamCount = 0 then begin
ALSAbeep(spkf(1000), 1000, vol, False, 0, true);
Halt;
end;

for ff := 1 to ParamCount do begin
if LoadFromFile(ParamStr(ff)) then begin
 WriteLn('Err');
 ALSAbeep(spkf(300), 1000, vol, False, 0, false);
 Halt(2);
end;
WriteLn('* Playing file: ' + fFileName);

for f := 0 to fs-1 do begin
 if a[f].duration < 1 then continue;
 if a[f].tone < 1 then begin
   sleep(a[f].duration);
 end else begin
   ALSAbeep(spkf(a[f].tone), a[f].duration, vol, False, 0, false);
 end;
end;
FreeMem(a);
end;

end.