program gorgclock;

{
    Clock panel for X.Org.
    For GNU/Linux.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2021  Artyomov Alexander
    http://self-made-free.ru/ (Ex http://aralni.narod.ru/)
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}
{$LONGSTRINGS ON}
{$RANGECHECKS ON}
{$SMARTLINK ON}
{$ASMMODE INTEL}
//{$CODEPAGE UTF8}
 
uses cthreads,classes,sysutils,x,xlib,xutil,xatom,strings;

type
    TGt  = class(TThread)
    public
         procedure AfterConstruction; override;
         procedure Execute; override;
    end;

  TMWMHints {MotifWmHints} = record
    flags : TAtom;
    functions : TAtom;
    decorations : TAtom;
    input_mode : TAtom;
    status : TAtom;
  end;
 
const
 WND_X=0;
 WND_Y=0;
 WND_WDT=600;
 WND_HGH=25;
 WND_MIN_WDT=150; //50;
 WND_MIN_HGH=0; //50;
 WND_BORDER_WDT=5;
 WND_TITLE='Clock panel';
 WND_ICON_TITLE='Clock panel';
 PRG_CLASS='ClockPanel';
 PROP_MWM_HINTS_ELEMENTS = 5;
 MWM_HINTS_DECORATIONS {: TAtom} = 1 shl 1;

mon_name : array [1..12] of string = ('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
wdn : array[0..6] of string = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');

var
    year : LongInt;
    month, day, hour, minute : byte;
    inittime : boolean = false;
    mousegrabbed : boolean = false;
    start_x, start_y : longint;

function inttofix2str(i : integer) : string;
begin result := inttostr(i);if 10 > i then result := '0' + result; end;
function Weekday(year, month, day: LongInt): byte;
begin
    if month < 3 then
    begin
	year := year - 1;
	month := month + 10;
    end
    else
	month := month - 2;
    Weekday := (day + 31 * month div 12 + year + year div 4 - year div 100 + year div 400) mod 7;
end;
function WeekdayRu(year, month, day: LongInt) : byte;
begin
result := Weekday(year, month, day);
if result = 0 then Exit(7);
end;

procedure SetWindowManagerHints(
 prDisplay: PDisplay;
 psPrgClass: PChar;
 argv: PPChar;
 argc: integer;
 nWnd: TWindow;
  x,
  y,
  nWidth,
  nHeight,
  nMinWidth,
  nMinHeight:integer;
 psTitle: PChar;
 psIconTitle: PChar;
 nIconPixmap: TPixmap
);
 
var
 rSizeHints: TXSizeHints;
 rWMHints: TXWMHints;
 rClassHint: TXClassHint;
 prWindowName, prIconName: TXTextProperty;

begin
 
if (XStringListToTextProperty(@psTitle, 1, @prWindowName)=0) or
    (XStringListToTextProperty(@psIconTitle, 1, @prIconName)=0) then
 begin
  writeln('No memory!');
  halt(1);
end;
 rSizeHints.flags:= PPosition OR PSize OR PMinSize;
 rSizeHints.min_width:= nMinWidth;
 rSizeHints.min_height:= nMinHeight;
 rWMHints.flags:= StateHint OR IconPixmapHint OR InputHint;
 rWMHints.initial_state:= NormalState;
 rWMHints.input:= 1; // True;
 rWMHints.icon_pixmap:= nIconPixmap;
 rClassHint.res_name:= argv[0];
 rClassHint.res_class:= psPrgClass;
 XSetWMProperties(prDisplay, nWnd, @prWindowName, @prIconName, argv, argc, @rSizeHints, @rWMHints, @rClassHint);
end;

var
 prDisplay: PDisplay;
 nScreenNum: integer;
 prGC: TGC;
 rEvent, sEvent: TXEvent;
 nWnd, wEE: TWindow;
 gt  : TThread;
  s : string;
Font : TFont;
 a, a1, prop, prop1, prop2, prop3 : TAtom;
               xia_motif_wm_hints : TAtom;
      xt : TXTextProperty;
      p : PPCHar;
  mwmhints: TMWMHints;
atom1, atom2 : TAtom;

procedure TGt.AfterConstruction;
begin
  inherited AfterConstruction;
  FreeOnTerminate := True;
end;

procedure TGt.Execute;
  var t : TSystemTime;
begin
while true do begin
GetLocalTime(t);
if (year <> t.Year) or (month <> t.Month) or (day <> t.Day) or (hour <> t.Hour) or (minute <> t.Minute) then begin
year := t.Year; month := t.Month; day := t.Day;
hour := t.Hour; minute := t.Minute;
inittime := true;
sevent.xexpose._type := Expose;
sevent.xexpose.x := 0;
sevent.xexpose.y := 0;
sevent.xexpose.width := 150;
sevent.xexpose.height := 150;
sevent.xexpose.count := 0;
XSendEvent(prdisplay, nwnd, true, 0, @sevent);
 XFlush(prdisplay);
end;
sleep(1000);
end;
end;
 
begin

XInitThreads;
 
 prDisplay:= XOpenDisplay(nil);
if prDisplay = nil then begin
  writeln('Can not connect to the X server!');
  halt (1);
 end;

nScreenNum:= XDefaultScreen(prDisplay);

//font := XLoadFont(prdisplay, '-*-courier-bold-r-normal-*-22-*-*-*-*-*-*');
font := XLoadFont(prdisplay, '-*-courier-bold-r-normal-*-22-*-*-*-*-*-*-*');
 
 nWnd:= XCreateSimpleWindow(prDisplay, XRootWindow (prDisplay, nScreenNum), WND_X, WND_Y, WND_WDT, WND_HGH, WND_BORDER_WDT, XBlackPixel (prDisplay, nScreenNum),
 XWhitePixel (prDisplay, nScreenNum));
 SetWindowManagerHints(prDisplay, PRG_CLASS, argv, argc, nWnd, WND_X, WND_Y, WND_WDT, WND_HGH, WND_MIN_WDT, WND_MIN_HGH, WND_TITLE, WND_ICON_TITLE, 0);
 XSelectInput(prDisplay, nWnd, ExposureMask OR KeyPressMask OR ButtonPressMask OR ButtonReleaseMask OR PointerMotionMask OR StructureNotifyMask);
{
KeyPressMask or KeyReleaseMask or
      ButtonPressMask or ButtonReleaseMask or
      EnterWindowMask or LeaveWindowMask or
      ButtonMotionMask or PointerMotionMask or
      ExposureMask or FocusChangeMask or
      StructureNotifyMask or PropertyChangeMask
}
a := XInternAtom(prdisplay, '_NET_WM_STATE', True);
if (a <> None) then begin
prop := XInternAtom(prdisplay, '_NET_WM_STATE_SKIP_TASKBAR', True);
XChangeProperty(prdisplay, nwnd, a, XA_ATOM, 32, PropModeAppend, @prop, 1);
prop1 := XInternAtom(prdisplay, '_NET_WM_STATE_SKIP_PAGER', True);
XChangeProperty(prdisplay, nwnd, a, XA_ATOM, 32, PropModeAppend, @prop1, 1);
prop2 := XInternAtom(prdisplay, '_NET_WM_STATE_ABOVE', True);
XChangeProperty(prdisplay, nwnd, a, XA_ATOM, 32, PropModeAppend, @prop2, 1);
//prop3 := XInternAtom(prdisplay, '_NET_WM_STATE_FULLSCREEN', True);
//XChangeProperty(prdisplay, nwnd, a, XA_ATOM, 32, PropModeAppend, @prop3, 1);
end;
xia_motif_wm_hints := XInternAtom(prDisplay, '_MOTIF_WM_HINTS', TBool(false));
    a1 := XInternAtom(prdisplay, '_MOTIF_WM_INFO', TBool(false));
    if a1 <> None then begin
      mwmhints.flags := MWM_HINTS_DECORATIONS;
      mwmhints.decorations := 0; // no decorations
      if xia_motif_wm_hints <> None then
      begin
        XChangeProperty(prdisplay, nwnd, xia_motif_wm_hints, XA_ATOM, 32, PropModeAppend, @mwmhints, PROP_MWM_HINTS_ELEMENTS);
      end;
    end;

 XMapWindow(prDisplay, nWnd);

gt := TGt.Create(True);
gt.Start;

atom1 := XInternAtom(prdisplay, 'WM_PROTOCOLS', 0);
atom2 := XInternAtom(prdisplay, 'WM_DELETE_WINDOW', 0);
XSetWMProtocols(prdisplay, nwnd, @atom2, 1);
 
while (true) do begin
  XNextEvent(prDisplay, @rEvent);
case (rEvent._type) of
  Expose:
begin
if (rEvent.xexpose.count <> 0) then continue;

if inittime = false then continue;

XClearWindow(prdisplay, nwnd);
    prGC:= XCreateGC (prDisplay, nWnd, 0, nil );
   XSetForeground(prDisplay, prGC, XBlackPixel (prDisplay, 0));
XSetFont(prdisplay, prgc, font);

s := IntToStr(hour) + ':' + IntToFix2Str(minute) + ' ' + mon_name[month] + ' (' + IntToStr(month) + ') ' +
wdn[Weekday(year, month, day)] + ' ' + IntToStr(day) + ' ' + IntToStr(year);
XDrawString(prDisplay, nWnd, prGC, 0, 20, PChar(s), strlen(PChar(s)));
   XFreeGC (prDisplay, prGC);
end;
 ButtonPress: begin
  XGrabPointer(prDisplay, nwnd, TBool(False),
      ButtonPressMask or ButtonReleaseMask or ButtonMotionMask or PointerMotionMask or EnterWindowMask or LeaveWindowMask,
      GrabModeAsync, GrabModeAsync,
      None, 0,
      CurrentTime); mousegrabbed := true; start_x := revent.xbutton.x; start_y := revent.xbutton.y;
              end;
 ButtonRelease: begin
  XUngrabPointer(prdisplay, CurrentTime); mousegrabbed := false;
                end;
MotionNotify: begin
if mousegrabbed then
XMoveWindow(prDisplay, nwnd, revent.xmotion.x_root - start_x, revent.xmotion.y_root - start_y);
              end;
DestroyNotify,
 KeyPress:
   begin
    XCloseDisplay(prDisplay);
    halt(0);
   end;
 ClientMessage: begin
 if((revent.xclient.message_type = atom1) and (revent.xclient.data.l[0] = atom2))
      then begin
          XDestroyWindow(prdisplay, nwnd);
      end;
break;
 end;
end;
 end;
end.
