#!/bin/sh -

readonly ROOT="$(realpath "$(dirname "$0")")";
readonly SRC="$ROOT/src";
readonly BUILD="$ROOT/build";

readonly LIB="$BUILD/libttar.so";
readonly CLI="$BUILD/ttar";

readonly CC='clang';

SONAME="libttar.so.1";

CFLAGS_SHARED=;
CFLAGS_SHARED="$CFLAGS_SHARED -std=c99";
CFLAGS_SHARED="$CFLAGS_SHARED -Wall -Wextra -Wpedantic";
CFLAGS_SHARED="$CFLAGS_SHARED -DNDEBUG";
#CFLAGS_SHARED="$CFLAGS_SHARED -gdwarf";
CFLAGS_SHARED="$CFLAGS_SHARED -march=native -mtune=native";
CFLAGS_SHARED="$CFLAGS_SHARED -funroll-loops -msse4a -fforce-addr -ffast-math";
readonly CFLAGS_SHARED;

CFLAGS_LIB="$CFLAGS_SHARED";
CFLAGS_LIB="$CFLAGS_LIB -O3";
CFLAGS_LIB="$CFLAGS_LIB -shared -fPIC";
CFLAGS_LIB="$CFLAGS_LIB -nolibc -ffreestanding";
#CFLAGS_LIB="$CFLAGS_LIB -DLIBTTAr_OPT_SLOW_CPU";
readonly CFLAGS_LIB;

CFLAGS_CLI="$CFLAGS_SHARED";
CFLAGS_CLI="$CFLAGS_CLI -O3 -ffast-math";
readonly CFLAGS_CLI;

LD_CLI="-L$BUILD -lpthread -lttar";
readonly LD_CLI;

LDFLAGS_LIB="-Wl,-soname=$SONAME,-lc";
LDFLAGS_LIB="$LDFLAGS_LIB -shared";
# library only uses memmove & memset from libc, but those should be builtin
LDFLAGS_LIB="$LDFLAGS_LIB -nolibc";
readonly LDFLAGS_LIB;

##############################################################################

if [ ! -e "$BUILD" ]; then
	mkdir -- "$BUILD" || exit $?;
fi
cp -- "$SRC/libttar.h" "$BUILD/" &
"$CC" $CFLAGS_LIB "$SRC/build_lib.c" -o "$LIB" $LDFLAGS_LIB;
"$CC" $CFLAGS_CLI "$SRC/build_cli.c" -o "$CLI" $LD_CLI;
wait;
