/* ///////////////////////////////////////////////////////////////////////////
//                                                                          //
// codec/tables_crc32.c                                                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Copyright (C) 2007, Aleksander Djuric                                    //
// Copyright (C) 2023-2025, Shane Seelig                                    //
// SPDX-License-Identifier: GPL-3.0-or-later                                //
//                                                                          //
/////////////////////////////////////////////////////////////////////////// */

#include <stdint.h>

#include "./common.h"

/* //////////////////////////////////////////////////////////////////////// */

/**@var crc32_table
 * @brief CRC lookup table for Sarwate's method
 * @note width   : 32-bit
 *       endian  : little
 *       poly    : 0xEDB88320u
**/
/*@unchecked@*/
BUILD_HIDDEN
const uint32_t crc32_table[256u] = {
#define T_C(x_x)	UINT32_C(x_x)
T_C(0x00000000), T_C(0x77073096), T_C(0xEE0E612C), T_C(0x990951BA),
T_C(0x076DC419), T_C(0x706AF48F), T_C(0xE963A535), T_C(0x9E6495A3),
T_C(0x0EDB8832), T_C(0x79DCB8A4), T_C(0xE0D5E91E), T_C(0x97D2D988),
T_C(0x09B64C2B), T_C(0x7EB17CBD), T_C(0xE7B82D07), T_C(0x90BF1D91),
T_C(0x1DB71064), T_C(0x6AB020F2), T_C(0xF3B97148), T_C(0x84BE41DE),
T_C(0x1ADAD47D), T_C(0x6DDDE4EB), T_C(0xF4D4B551), T_C(0x83D385C7),
T_C(0x136C9856), T_C(0x646BA8C0), T_C(0xFD62F97A), T_C(0x8A65C9EC),
T_C(0x14015C4F), T_C(0x63066CD9), T_C(0xFA0F3D63), T_C(0x8D080DF5),
T_C(0x3B6E20C8), T_C(0x4C69105E), T_C(0xD56041E4), T_C(0xA2677172),
T_C(0x3C03E4D1), T_C(0x4B04D447), T_C(0xD20D85FD), T_C(0xA50AB56B),
T_C(0x35B5A8FA), T_C(0x42B2986C), T_C(0xDBBBC9D6), T_C(0xACBCF940),
T_C(0x32D86CE3), T_C(0x45DF5C75), T_C(0xDCD60DCF), T_C(0xABD13D59),
T_C(0x26D930AC), T_C(0x51DE003A), T_C(0xC8D75180), T_C(0xBFD06116),
T_C(0x21B4F4B5), T_C(0x56B3C423), T_C(0xCFBA9599), T_C(0xB8BDA50F),
T_C(0x2802B89E), T_C(0x5F058808), T_C(0xC60CD9B2), T_C(0xB10BE924),
T_C(0x2F6F7C87), T_C(0x58684C11), T_C(0xC1611DAB), T_C(0xB6662D3D),
T_C(0x76DC4190), T_C(0x01DB7106), T_C(0x98D220BC), T_C(0xEFD5102A),
T_C(0x71B18589), T_C(0x06B6B51F), T_C(0x9FBFE4A5), T_C(0xE8B8D433),
T_C(0x7807C9A2), T_C(0x0F00F934), T_C(0x9609A88E), T_C(0xE10E9818),
T_C(0x7F6A0DBB), T_C(0x086D3D2D), T_C(0x91646C97), T_C(0xE6635C01),
T_C(0x6B6B51F4), T_C(0x1C6C6162), T_C(0x856530D8), T_C(0xF262004E),
T_C(0x6C0695ED), T_C(0x1B01A57B), T_C(0x8208F4C1), T_C(0xF50FC457),
T_C(0x65B0D9C6), T_C(0x12B7E950), T_C(0x8BBEB8EA), T_C(0xFCB9887C),
T_C(0x62DD1DDF), T_C(0x15DA2D49), T_C(0x8CD37CF3), T_C(0xFBD44C65),
T_C(0x4DB26158), T_C(0x3AB551CE), T_C(0xA3BC0074), T_C(0xD4BB30E2),
T_C(0x4ADFA541), T_C(0x3DD895D7), T_C(0xA4D1C46D), T_C(0xD3D6F4FB),
T_C(0x4369E96A), T_C(0x346ED9FC), T_C(0xAD678846), T_C(0xDA60B8D0),
T_C(0x44042D73), T_C(0x33031DE5), T_C(0xAA0A4C5F), T_C(0xDD0D7CC9),
T_C(0x5005713C), T_C(0x270241AA), T_C(0xBE0B1010), T_C(0xC90C2086),
T_C(0x5768B525), T_C(0x206F85B3), T_C(0xB966D409), T_C(0xCE61E49F),
T_C(0x5EDEF90E), T_C(0x29D9C998), T_C(0xB0D09822), T_C(0xC7D7A8B4),
T_C(0x59B33D17), T_C(0x2EB40D81), T_C(0xB7BD5C3B), T_C(0xC0BA6CAD),
T_C(0xEDB88320), T_C(0x9ABFB3B6), T_C(0x03B6E20C), T_C(0x74B1D29A),
T_C(0xEAD54739), T_C(0x9DD277AF), T_C(0x04DB2615), T_C(0x73DC1683),
T_C(0xE3630B12), T_C(0x94643B84), T_C(0x0D6D6A3E), T_C(0x7A6A5AA8),
T_C(0xE40ECF0B), T_C(0x9309FF9D), T_C(0x0A00AE27), T_C(0x7D079EB1),
T_C(0xF00F9344), T_C(0x8708A3D2), T_C(0x1E01F268), T_C(0x6906C2FE),
T_C(0xF762575D), T_C(0x806567CB), T_C(0x196C3671), T_C(0x6E6B06E7),
T_C(0xFED41B76), T_C(0x89D32BE0), T_C(0x10DA7A5A), T_C(0x67DD4ACC),
T_C(0xF9B9DF6F), T_C(0x8EBEEFF9), T_C(0x17B7BE43), T_C(0x60B08ED5),
T_C(0xD6D6A3E8), T_C(0xA1D1937E), T_C(0x38D8C2C4), T_C(0x4FDFF252),
T_C(0xD1BB67F1), T_C(0xA6BC5767), T_C(0x3FB506DD), T_C(0x48B2364B),
T_C(0xD80D2BDA), T_C(0xAF0A1B4C), T_C(0x36034AF6), T_C(0x41047A60),
T_C(0xDF60EFC3), T_C(0xA867DF55), T_C(0x316E8EEF), T_C(0x4669BE79),
T_C(0xCB61B38C), T_C(0xBC66831A), T_C(0x256FD2A0), T_C(0x5268E236),
T_C(0xCC0C7795), T_C(0xBB0B4703), T_C(0x220216B9), T_C(0x5505262F),
T_C(0xC5BA3BBE), T_C(0xB2BD0B28), T_C(0x2BB45A92), T_C(0x5CB36A04),
T_C(0xC2D7FFA7), T_C(0xB5D0CF31), T_C(0x2CD99E8B), T_C(0x5BDEAE1D),
T_C(0x9B64C2B0), T_C(0xEC63F226), T_C(0x756AA39C), T_C(0x026D930A),
T_C(0x9C0906A9), T_C(0xEB0E363F), T_C(0x72076785), T_C(0x05005713),
T_C(0x95BF4A82), T_C(0xE2B87A14), T_C(0x7BB12BAE), T_C(0x0CB61B38),
T_C(0x92D28E9B), T_C(0xE5D5BE0D), T_C(0x7CDCEFB7), T_C(0x0BDBDF21),
T_C(0x86D3D2D4), T_C(0xF1D4E242), T_C(0x68DDB3F8), T_C(0x1FDA836E),
T_C(0x81BE16CD), T_C(0xF6B9265B), T_C(0x6FB077E1), T_C(0x18B74777),
T_C(0x88085AE6), T_C(0xFF0F6A70), T_C(0x66063BCA), T_C(0x11010B5C),
T_C(0x8F659EFF), T_C(0xF862AE69), T_C(0x616BFFD3), T_C(0x166CCF45),
T_C(0xA00AE278), T_C(0xD70DD2EE), T_C(0x4E048354), T_C(0x3903B3C2),
T_C(0xA7672661), T_C(0xD06016F7), T_C(0x4969474D), T_C(0x3E6E77DB),
T_C(0xAED16A4A), T_C(0xD9D65ADC), T_C(0x40DF0B66), T_C(0x37D83BF0),
T_C(0xA9BCAE53), T_C(0xDEBB9EC5), T_C(0x47B2CF7F), T_C(0x30B5FFE9),
T_C(0xBDBDF21C), T_C(0xCABAC28A), T_C(0x53B39330), T_C(0x24B4A3A6),
T_C(0xBAD03605), T_C(0xCDD70693), T_C(0x54DE5729), T_C(0x23D967BF),
T_C(0xB3667A2E), T_C(0xC4614AB8), T_C(0x5D681B02), T_C(0x2A6F2B94),
T_C(0xB40BBE37), T_C(0xC30C8EA1), T_C(0x5A05DF1B), T_C(0x2D02EF8D)
#undef T_C
};

/* EOF //////////////////////////////////////////////////////////////////// */
