https://github.com/petrovich/petrovich-ruby.git

![Petrovich](petrovich.png)

Склонение падежей русских имён, фамилий и отчеств. Вы задаёте начальное имя
в именительном падеже, а получаете в нужном вам. Просто посмотрите на
[демонстрацию](http://petrovich.nlpub.ru/) и сделайте так же.

Petrovich также позволяет определять пол по имени, фамилии, отчеству.

[![RubyGems][rubygems_badge]][rubygems_link] [![Build Status][tests_badge]][tests_link]

[rubygems_badge]: https://badge.fury.io/rb/petrovich.svg
[rubygems_link]: https://rubygems.org/gems/petrovich
[tests_badge]: https://github.com/petrovich/petrovich-ruby/actions/workflows/test.yml/badge.svg
[tests_link]: https://github.com/petrovich/petrovich-ruby/actions/workflows/test.yml

## Установка

Добавьте в Gemfile:

```ruby
gem 'petrovich', '~> 1.0'
```

Установите гем cредствами Bundler:

    $ bundle

Или установите его отдельно:

    $ gem install petrovich

## Зависимости

Для работы гема требуется Ruby не младше версии 1.9.3. Petrovich не
привязан к Ruby on Rails и может свободно использоваться практически
в любых приложениях и библиотеках на языке Ruby.

## Использование

Вы задаёте начальные значения (фамилию, имя и отчество) в именительном
падеже, а библиотека делает всё остальное. Если вам известен пол - укажите его, это повысит скорость работы и даст более точные результаты. Если пол не указан, то Petrovich попытается определить его автоматически. Примеры:

```ruby
# Склонение в дательный падеж при помощи метода `dative`. Существуют методы `genitive`,
# `dative`, `accusative`, `instrumental`, `prepositional`.
Petrovich(
  lastname: 'Салтыков-Щедрин',
  firstname: 'Михаил',
  middlename: 'Евграфович',
).dative.to_s # => Салтыкову-Щедрину Михаилу Евграфовичу

# Склонение в творительный падеж с использованием метода `to` и возвратом отчества.
# Аналогично можно вызвать метод `firstname`, чтобы получить имя.
Petrovich(
  firstname: 'Иван',
  middlename: 'Петрович',
).to(:instrumental).middlename # => Петровича

# Склонение с указанием пола. В данном случае, по имени и фамилии невозможно определить пол
# человека, поэтому, если вам известен пол, то всегда передавайте его в аргументах,
# чтобы склонение было верным.
# Если пол неизвестен, то гем попытается определить его самостоятельно.
# Пол должен быть указан в виде строки или символа. Возможные значения: male, female.
Petrovich(
  lastname: 'Андрейчук',
  firstname: 'Саша',
  gender: :male
).to(:instrumental).to_s # => Андрейчуку Саше
```

Полный список поддерживаемых методов склонения приведён
в таблице ниже.

| Метод          | Падеж        | Характеризующий вопрос |
|----------------|--------------|------------------------|
| genitive       | родительный  | Кого?                  |
| dative         | дательный    | Кому?                  |
| accusative     | винительный  | Кого?                  |
| instrumental   | творительный | Кем?                   |
| prepositional  | предложный   | О ком?                 |

### Определение пола

Примеры:

```ruby
Petrovich(
  lastname: 'Склифасовский'
).gender # => :male

Petrovich(
  firstname: 'Александра',
  lastname: 'Склифасовская'
).female? # => true

Petrovich(
  lastname: 'Склифасовский'
).male? # => true

Petrovich(
  firstname: 'Саша',
  lastname: 'Андрейчук'
).androgynous? # => true

Petrovich(
  firstname: 'Саша',
  lastname: 'Андрейчук'
  gender: :male,
).male? # => true
```

## Интерфейс командной строки

Примеры вызовов:

```bash
petrovich -l Иванов -f Иван -m Иванович -g male -c accusative
petrovich -l Иванов -f Иван -m Иванович -c accusative -n
petrovich -l Иванов -f Иван -m Иванович -c accusative -o
```

Подробное руководство: `petrovich --help`.

## Модульные тесты

Для запуска тестов достаточно выполнить команду `rake`.
Чтобы запустить тесты "аккуратности" по словарю фамилий, выполните команду `rake evaluate`, после выполнения вы увидите подробный отчёт.

## Разработчики

 * [Андрей Козлов](https://github.com/tanraya)
 * [Дмитрий Усталов](https://github.com/dustalov)

## Благодарности

Эта библиотека не была бы столь замечательна без содействия Павла Скрылёва,
Никиты Помящего, Игоря Бочкарёва, и других хороших людей.

Отдельная благодарность [Андрею Бильжо](https://ru.wikipedia.org/wiki/%D0%91%D0%B8%D0%BB%D1%8C%D0%B6%D0%BE,_%D0%90%D0%BD%D0%B4%D1%80%D0%B5%D0%B9_%D0%93%D0%B5%D0%BE%D1%80%D0%B3%D0%B8%D0%B5%D0%B2%D0%B8%D1%87) за то, что разрешил нам использовать персонаж Петровича в нашем логотипе.

## Портирование

Существуют официальные порты Petrovich на другие языке и платформы. Их список
доступен по адресу <https://github.com/petrovich>. Ребята, спасибо!

## Содействие

Если вы нашли баги как программной части, так и в базе правил, то вы всегда
можете форкнуть репозиторий и внести необходимые изменения. Ваша помощь не
останется незамеченной! Если вы заметили ошибки при склонении падежей имён,
фамилий или отчеств, можете написать об этом в Issues на GitHub.
Проблема будет сразу же исследована и, по возможности, решена.

Не стесняйтесь добавлять улучшения.

1. Fork it
2. Create your feature branch (`git checkout -b my-new-feature`)
3. Commit your changes (`git commit -am 'Add some feature'`)
4. Push to the branch (`git push origin my-new-feature`)
5. Create new Pull Request
