program benchmark_unicode_strings;

{$MODE OBJFPC}{$H+}
{$RANGECHECKS ON}
{$OPTIMIZATION LEVEL3}

uses
  SysUtils, DateUtils,
  string4unit, ucs4unit;

const
  TEST_ITERATIONS = 100000;
  TEST_STRING = 'Тестовая строка для проверки производительности. 测试性能的字符串. パフォーマンステスト用の文字列.';

procedure RunString4Benchmark;
var
  i: Integer;
  StartTime, EndTime: TDateTime;
  S1, S2, S3: string4;
begin
  WriteLn('=== string4 (класс) benchmark ===');
  
  // Тест создания строк
  StartTime := Now;
  for i := 1 to TEST_ITERATIONS do
  begin
    S1 := string4.Create;
    S1.FromUTF8(TEST_STRING);
    S1.Free;
  end;
  EndTime := Now;
  WriteLn('Create + FromUTF8: ', MilliSecondsBetween(EndTime, StartTime), ' ms');

  // Тест конкатенации
  S1 := string4.Create;
  S2 := string4.Create;
  S1.FromUTF8(TEST_STRING);
  S2.FromUTF8(TEST_STRING);
  
  StartTime := Now;
  for i := 1 to TEST_ITERATIONS div 10 do
  begin
    S3 := S1.Concat(S2);
    S3.Free;
  end;
  EndTime := Now;
  WriteLn('Concat: ', MilliSecondsBetween(EndTime, StartTime), ' ms (', TEST_ITERATIONS div 10, ' iterations)');
  
  S1.Free;
  S2.Free;

  // Тест реверса строки
  S1 := string4.Create;
  S1.FromUTF8(TEST_STRING);
  
  StartTime := Now;
  for i := 1 to TEST_ITERATIONS do
  begin
    S1.Reverse;
    S1.Reverse;
  end;
  EndTime := Now;
  WriteLn('Reverse: ', MilliSecondsBetween(EndTime, StartTime), ' ms');
  
  S1.Free;
end;

procedure RunUCS4Benchmark;
var
  i: Integer;
  StartTime, EndTime: TDateTime;
  S1, S2, S3: ucs4;
begin
  WriteLn('=== ucs4 (объект) benchmark ===');
  
  // Инициализация
  S1.Init;
  S2.Init;
  S3.Init;

  // Тест создания строк
  StartTime := Now;
  for i := 1 to TEST_ITERATIONS do
  begin
    S1.FromUTF8(TEST_STRING);
    S1.Clear;
  end;
  EndTime := Now;
  WriteLn('FromUTF8 + Clear: ', MilliSecondsBetween(EndTime, StartTime), ' ms');

  // Тест конкатенации
  S1.FromUTF8(TEST_STRING);
  S2.FromUTF8(TEST_STRING);
  
  StartTime := Now;
  for i := 1 to TEST_ITERATIONS do // Увеличили количество итераций!
  begin
    S3 := S1.Concat(S2);
    S3.Clear;
  end;
  EndTime := Now;
  WriteLn('Concat: ', MilliSecondsBetween(EndTime, StartTime), ' ms (', TEST_ITERATIONS, ' iterations)');

  // Тест реверса строки
  S1.FromUTF8(TEST_STRING);
  
  StartTime := Now;
  for i := 1 to TEST_ITERATIONS do
  begin
    S1.Reverse;
    S1.Reverse;
  end;
  EndTime := Now;
  WriteLn('Reverse: ', MilliSecondsBetween(EndTime, StartTime), ' ms');
  
  S1.Clear;
end;

begin
  try
    RunString4Benchmark;
    WriteLn;
    RunUCS4Benchmark;
  except
    on E: Exception do
      WriteLn('Error: ', E.ClassName, ': ', E.Message);
  end;
  WriteLn('Benchmark completed. Press Enter to exit.');
  ReadLn;
end.