unit ucs4opunit;

{
    UCS4 operaors unit.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025  Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}
{$RANGECHECKS ON}
{$OPTIMIZATION LEVEL3}
{$INLINE ON}
{$CODEPAGE UTF8}

interface

uses ucs4unit;

operator = (s1,s2:ucs4)r:bytebool;
operator = (s1:ucs4;s2:string)r:bytebool;
operator + (s1,s2:ucs4)r:ucs4;
operator + (s:ucs4;c:DWord)r:ucs4;
operator := (const s: utf8string)r:ucs4;

implementation

operator = (s1,s2:ucs4)r:bytebool;
var f:LongInt;
begin
if s1.Length <> s2.Length then Exit(false);
for f := 0 to s1.Length-1 do if s1[f] <> s2[f] then Exit(false);
Exit(true);
end;

operator = (s1:ucs4;s2:string)r:bytebool;
var tmp:ucs4;
begin
tmp.Init;
tmp.FromUTF8(s2);
r:= s1=tmp;
tmp.Clear;
end;

operator + (s1,s2:ucs4)r:ucs4;
begin
Exit(s1.Concat(s2));
end;

operator + (s:ucs4;c:DWord)r:ucs4;
var tmp:ucs4;
begin
tmp.Init(1);
tmp[0]:=c;
r := s.Concat(tmp);
tmp.Clear;
end;

operator := (const s: utf8string)r:ucs4;
begin
r.Init;
r.FromUTF8(s);
end;

end.