//Compile: gcc xgrabkey.c `pkg-config --cflags --libs x11`

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>

int
main ()
{
	Window root;
	Display *dpy = NULL;

	dpy = XOpenDisplay(0);
	if (dpy == NULL) {
		printf("Open Display Failed\n");
		return -1;
	}

	root = DefaultRootWindow(dpy);

	unsigned int mod = 0;
	mod = mod| ControlMask|ShiftMask;

//	XGrabKey(dpy, AnyKey, mod, root, True, GrabModeAsync, GrabModeAsync);
	XGrabKey(dpy, XK_F12, mod, root, True, GrabModeAsync, GrabModeAsync);

	XEvent event;
	for (;;) {
		XNextEvent(dpy, &event);
		printf("Key event\n");
		if (event.type == KeyPress) {
			printf("Key press\n");
		}
	}

	XAllowEvents(dpy, AsyncKeyboard, CurrentTime);
	XUngrabKey(dpy, AnyKey, AnyModifier, root);
	XSync(dpy, False);

	XCloseDisplay(dpy);

	return 0;
}