unit DataUtils;
{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
{$ASMMODE INTEL}
interface

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


type
TDoubleArray = array of Double;
TDoubleMatrix = array of TDoubleArray;
TDoubleMatrixArray = array of TDoubleMatrix;
TDoubleFunc = function(x: Double): Double;
TIntegerArray = array of Integer;

TAdamState = record
  M, V: TDoubleMatrix;
  Beta1, Beta2: Double;
  Timestep: Integer;
  GradientClipValue: Double;
end;

TAdamVectorState = record
  M, V: TDoubleArray;
  Beta1, Beta2: Double;
  Timestep: Integer;
end;

function IfThen(b:bytebool;s1,s2:string):string; inline; overload;

implementation

{$I asmf.inc}

function IfThen(b:bytebool;s1,s2:string):string;
begin
if b then Exit(s1) else Exit(s2);
end;

end.