unit MMTextFileReader;
{$MODE OBJFPC}{$H+}
{$MODESWITCH ADVANCEDRECORDS}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


interface

uses
  SysUtils, Classes, BaseUnix, Unix, termio, Math, syscall;

type
  TMMTextFile = record
    Data: PByte;//Pointer;
    Size, Old, LC: Int64;
    FileName: String;
    IsMapped: Boolean;
    FFileHandle: cint;
  end;

function MMTOpen(var fp: TMMTextFile;fn:string):bytebool;
procedure MMTClose(var fp:TMMTextFile);
function MMTNextLine(var fp:TMMTextFile; var s:string):bytebool;

implementation

function MMTOpen(var fp: TMMTextFile;fn:string):bytebool;
begin
  fp.FileName := fn;
  fp.IsMapped := False;

  WriteLn('MMAP File: ', fn);
  fp.FFileHandle := FpOpen(fp.FileName, O_RDONLY or O_LARGEFILE);
  if fp.FFileHandle = -1 then begin
    WriteLn('Cannot open file ', fn);
    Exit(true);
  end;

  fp.Size := FpLSeek(fp.FFileHandle, 0, SEEK_END);
  FpLSeek(fp.FFileHandle, 0, SEEK_SET);

  fp.Data := PByte(FpMMap(nil, fp.Size, PROT_READ, MAP_SHARED, fp.FFileHandle, 0));
  if fp.Data = Pointer(-1) then begin
    FpClose(fp.FFileHandle);
    WriteLn('MMap failed');
    Exit(true);
  end;
  
  fp.IsMapped := True;

fp.Old := 0; fp.LC := 0;
Exit(false);
end;

procedure MMTClose(var fp:TMMTextFile);
begin
  if fp.IsMapped then begin
    FpMUnMap(fp.Data, fp.Size);
    FpClose(fp.FFileHandle);
  end;
end;

function MMTNextLine(var fp:TMMTextFile; var s:string):bytebool;
var f:Int64;
begin
s := '';
if fp.Old > fp.Size-1 then Exit(false);

for f := fp.Old to fp.Size-1 do begin
 if (fp.Data[f]=byte(#10)) then begin
  SetLength(s, f-fp.Old);
  if Length(s) > 0 then Move(fp.Data[fp.Old], s[1], Length(s));
  fp.Old:=f+1;
  Inc(fp.LC);
  Exit(true);
 end; {end if}
end; {next f}

if (fp.Data[f]=byte(#10)) then Exit(false);
SetLength(s, f-fp.Old+1);
if Length(s) > 0 then Move(fp.Data[fp.Old], s[1], Length(s));
fp.Old:=f+1;
Inc(fp.LC);
Exit(true);
end;

end.