unit PositionalEncoding;
{$MODE OBJFPC}{$H+}
{$ASMMODE INTEL}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


interface

uses
  Math, DataUtils, MatrixOps,SysUtils;

function GetPositionalEncoding(maxLen, dModel: Integer): TDoubleMatrix;
function AddPositionalEncoding(const input, posEnc: TDoubleMatrix): TDoubleMatrix;
procedure AddPositionalEncodingToSequence(var sequence: TDoubleMatrix; maxSeqLength: Integer);

 function CreatePositionalEncoding(maxSeqLength, embeddingSize: Integer): TDoubleMatrix;

implementation

uses Transformer;

{$I asmf.inc}

function GetPositionalEncoding(maxLen, dModel: Integer): TDoubleMatrix;
var
  pos, i: Integer;
  angle: Double;
begin 
  // ЗАЩИТА ОТ НЕКОРРЕКТНЫХ ПАРАМЕТРОВ!
  if (maxLen <= 0) or (dModel <= 0) then begin
    WriteLn('ОШИБКА GetPositionalEncoding: maxLen=', maxLen, ' dModel=', dModel);
    SetLength(Result, 1, 1);
    Result[0][0] := 0.0;
    Exit;
  end;

  SetLength(Result, maxLen, dModel);
  for pos := 0 to maxLen - 1 do
    for i := 0 to (dModel shr 1) - 1 do begin
      angle := pos / Power(10000, 2 * i / dModel);
      Result[pos][2*i] := Sin(angle);
      if 2*i+1 < dModel then
        Result[pos][2*i+1] := Cos(angle);
    end;
end;

function AddPositionalEncoding(const input, posEnc: TDoubleMatrix): TDoubleMatrix;
var
  i, j: Integer;
begin
  // Проверяем совпадение размерностей по столбцам (embedding size)
  if Length(input[0]) <> Length(posEnc[0]) then begin
    WriteLn('ОШИБКА AddPositionalEncoding: Несовпадение embedding size');
    WriteLn('  input cols: ', Length(input[0]));
    WriteLn('  posEnc cols: ', Length(posEnc[0]));
    Halt;
  end;

  SetLength(Result, Length(input), Length(input[0]));

  for i := 0 to High(input) do begin
    for j := 0 to High(input[0]) do begin
      if i < Length(posEnc) then
        Result[i][j] := input[i][j] + posEnc[i][j]
      else
        Result[i][j] := input[i][j]; // Для последовательностей длиннее maxLen
    end;
  end;
end;

procedure AddPositionalEncodingToSequence(var sequence: TDoubleMatrix; maxSeqLength: Integer);
var
  i, j, actualMaxLength: Integer;
  posEnc: TDoubleMatrix;
begin
  WriteLn('      AddPositionalEncodingToSequence: начат');
  WriteLn('        sequence до: ', Length(sequence), 'x', 
          IfThen(Length(sequence) > 0, IntToStr(Length(sequence[0])), '0'));

  // ✅ ЗАЩИТА: Проверяем входные данные
  if (Length(sequence) = 0) or (Length(sequence[0]) = 0) then begin
    WriteLn('ОШИБКА: Пустая sequence в AddPositionalEncodingToSequence');
    Exit;
  end;

  // ✅ ИСПРАВЛЕНИЕ: Убедимся, что maxSeqLength корректен
  if maxSeqLength <= 0 then begin
    actualMaxLength := Length(sequence);
    WriteLn('        Исправляем maxSeqLength с ', maxSeqLength, ' на ', actualMaxLength);
  end else
    actualMaxLength := Min(maxSeqLength, Length(sequence));

  WriteLn('        actualMaxLength: ', actualMaxLength);

  // Создаем позиционное кодирование
  posEnc := CreatePositionalEncoding(actualMaxLength, Length(sequence[0]));
  WriteLn('        posEnc создан: ', Length(posEnc), 'x', 
          IfThen(Length(posEnc) > 0, IntToStr(Length(posEnc[0])), '0'));

  // ✅ ЗАЩИТА: Проверяем размерности
  if (Length(posEnc) = 0) or (Length(posEnc[0]) = 0) then
  begin
    WriteLn('ОШИБКА: Пустое позиционное кодирование');
    Exit;
  end;

  if (Length(sequence) < Length(posEnc)) or (Length(sequence[0]) <> Length(posEnc[0])) then
  begin
    WriteLn('ОШИБКА: Несовпадение размеров sequence и posEnc');
    WriteLn('        sequence: ', Length(sequence), 'x', Length(sequence[0]));
    WriteLn('        posEnc: ', Length(posEnc), 'x', Length(posEnc[0]));
    Exit;
  end;

  // Применяем позиционное кодирование
  for i := 0 to actualMaxLength - 1 do begin
    // ✅ ДВОЙНАЯ ПРОВЕРКА ГРАНИЦ
    if (i < Length(sequence)) and (i < Length(posEnc)) then begin
      for j := 0 to High(sequence[i]) do begin
        if j < Length(posEnc[i]) then begin
          sequence[i][j] := sequence[i][j] + posEnc[i][j];
        end;
      end;
    end;
  end;

  WriteLn('        sequence после: ', Length(sequence), 'x', Length(sequence[0]));
  WriteLn('      AddPositionalEncodingToSequence: завершен');
end;




function CreatePositionalEncoding(maxSeqLength, embeddingSize: Integer): TDoubleMatrix;
var
  i, j: Integer;
  angle: Double;
begin
  // ✅ ЗАЩИТА: Проверяем валидность параметров
  if (maxSeqLength <= 0) or (embeddingSize <= 0) then begin
    WriteLn('ОШИБКА: CreatePositionalEncoding с невалидными параметрами: ', maxSeqLength, 'x', embeddingSize);
    SetLength(Result, 0, 0);
    Exit;
  end;

  SetLength(Result, maxSeqLength, embeddingSize);

  for i := 0 to maxSeqLength - 1 do begin
    for j := 0 to embeddingSize - 1 do begin
      if (j and 1) = 0 then begin
        angle := i / Power(10000, j / embeddingSize);
        Result[i][j] := Sin(angle);
      end else begin
        angle := i / Power(10000, (j - 1) / embeddingSize);
        Result[i][j] := Cos(angle);
      end;
    end;
  end;
end;

end.