program TransformerDemoOld;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


uses
  Transformer, MatrixOps, DataUtils;

var
  model: TTransformer;
  config: TTransformerConfig;
  input, output: TDoubleMatrix;
begin
  // Простая конфигурация для теста
  config.InputSize := 64;
  config.NumLayers := 2;
  config.NumHeads := 2;
  config.FFNDim := 128;
  config.MaxSeqLength := 50;
  config.DropoutRate := 0.1;

  // Инициализация
  InitTransformer(model, config);

  // Тестовые данные
  input := CreateRandomMatrix(5, config.InputSize); // 5 токенов

  // Прямой проход
  ForwardTransformer(model, input, output);

  // Очистка
  FreeTransformer(model);

  WriteLn('Transformer успешно выполнил прямой проход! Размер вывода: ', 
          Length(output), 'x', Length(output[0]));
  
end.