
function Sqrt(x: Double): Double; assembler; nostackframe; override;
asm
  sqrtsd xmm0, xmm0
end;

function Power(x: Double; n: Integer): Double; override;
var
res, base: Double;
exp: Integer;
begin
if n = 0 then Exit(1.0);
if n < 0 then
begin
base := 1.0 / x;
exp := -n;
end
else
begin
base := x;
exp := n;
end;

res := 1.0;
while exp > 0 do
begin
if (exp and 1) <> 0 then
res := res * base;
base := base * base;
exp := exp shr 1;
end;
Result := res;
end;

function Power(x, y: Double): Double; override;
begin
// общий случай — без оптимизаций
Exit(Exp(y * Ln(x)));
end;
