program cleansrc;
{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
{$MODESWITCH UNICODESTRINGS}
{$CODEPAGE UTF8}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


uses ucs4unit,ucs4opunit,ucs4functionsunit,ucs4multilineunit,SysUtils;

const
  space_char:UnicodeChar = ' ';
  tab_char:UnicodeChar = #9;

var
  ml:ucs4multiline;
  f:LongInt;
  count:LongInt=0;
fp:Text;

function isEmpty(s:ucs4):bytebool;
var f: LongInt; a:LongInt = 0;
begin
for f := 0 to s.Length-1 do begin
 if (s[f] = Ord(space_char)) or (s[f] = Ord(tab_char)) then begin
  Inc(a);
 end else begin
  Exit(false);
 end;
end;
Inc(count,a);
Exit(true);
end;

begin
if ParamCount < 1 then begin
 WriteLn('Use: ',ParamStr(0),' filename.ext');
 Halt;
end;

ml.Init;

ml.LoadFromFile(ParamStr(1));
WriteLn('Loaded ',ml.Count, ' lines.');

Assign(fp, ParamStr(1)+'.cleaned');
ReWrite(fp);

if ml.Count > 0 then begin
for f := 0 to ml.Count-1 do begin

if (ml[f].Length = 0) or isEmpty(ml[f]) then begin
WriteLn(fp);
end else begin
 if f < ml.Count-1 then
  WriteLn(fp, ml[f].ToUtf8)
 else
  Write(fp, ml[f].ToUtf8);  
end;

end; {next f}
end; {end if}

Close(fp);

ml.Clear;

WriteLn('Cleaned ',count, ' symbols');

end.