unit DateTimePlugin;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


{$MODE OBJFPC}{$H+}

interface

uses
  PluginInterface, SysUtils, DateUtils, StrUtils;

type
  TDateTimePlugin = class(TInterfacedObject, IPlugin)
  public
    function CanHandle(const Input: string): Boolean;
    function HandleInput(const Input: string): string;
    function GetName: string;
  end;

implementation

function TDateTimePlugin.CanHandle(const Input: string): Boolean;
var
  LowerInput: string;
begin
  LowerInput := LowerCase(Trim(Input));
  
  // Проверяем явные запросы о времени и дате
  Result := 
    (LowerInput = 'время') or
    (LowerInput = 'дата') or
    (LowerInput = 'который час') or
    (LowerInput = 'сколько времени') or
    (LowerInput = 'текущее время') or
    (LowerInput = 'какое сегодня число') or
    (LowerInput = 'текущая дата') or
    (Pos('время', LowerInput) > 0) or
    (Pos('час', LowerInput) > 0) or
    (Pos('дата', LowerInput) > 0) or
    (Pos('число', LowerInput) > 0) or
    (Pos('день', LowerInput) > 0) or
    (Pos('месяц', LowerInput) > 0) or
    (Pos('год', LowerInput) > 0);
    
  WriteLn('[DateTimePlugin] Проверка "', Input, '": ', Result);
end;

function TDateTimePlugin.HandleInput(const Input: string): string;
var
  LowerInput: string;
  CurrentTime: TDateTime;
begin
  CurrentTime := Now;
  LowerInput := LowerCase(Trim(Input));
  
  if (LowerInput = 'время') or 
     (LowerInput = 'который час') or 
     (LowerInput = 'сколько времени') or 
     (LowerInput = 'текущее время') or
     (Pos('время', LowerInput) > 0) or
     (Pos('час', LowerInput) > 0) then
  begin
    Result := 'Сейчас время: ' + FormatDateTime('hh:nn:ss', CurrentTime);
  end
  else if (LowerInput = 'дата') or 
          (LowerInput = 'какое сегодня число') or 
          (LowerInput = 'текущая дата') or
          (Pos('дата', LowerInput) > 0) or
          (Pos('число', LowerInput) > 0) or
          (Pos('день', LowerInput) > 0) or
          (Pos('месяц', LowerInput) > 0) or
          (Pos('год', LowerInput) > 0) then
  begin
    Result := 'Сегодня: ' + FormatDateTime('dd.mm.yyyy', CurrentTime);
  end
  else
  begin
    Result := 'Сейчас ' + FormatDateTime('hh:nn:ss', CurrentTime) + ', сегодня ' + FormatDateTime('dd.mm.yyyy', CurrentTime);
  end;
  
  WriteLn('[DateTimePlugin] Обработано: "', Input, '" -> "', Result, '"');
end;

function TDateTimePlugin.GetName: string;
begin
  Result := 'DateTimePlugin v1.4';
end;

end.