program FuzzySearchDemo;
{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


uses
  FuzzySearchUnit;

var
  SearchEngine: TFuzzySearchEngine;
  Results: TFuzzySearchResults;
  i: Integer;
begin
  // Инициализация с моделью Word2Vec
  SearchEngine := TFuzzySearchEngine.Create('word2vec.model');

  try
    // Добавление текстов в поисковый индекс
    SearchEngine.AddText('Привет, как дела?');
    SearchEngine.AddText('Здравствуйте, чем могу помочь?');
    SearchEngine.AddText('Добрый день, что вас интересует?');
    SearchEngine.AddText('Приветствую! Как ваши успехи?');
    SearchEngine.AddText('Hi, how are you?');
    SearchEngine.AddText('Hello, what can I do for you?');

    // Поиск
    Results := SearchEngine.Search('Привет', 3);

    // Вывод результатов
    WriteLn('Результаты поиска для "Привет":');
    for i := 0 to High(Results) do
      WriteLn(i+1, '. ', Results[i].Text, ' (схожесть: ', Results[i].Similarity:0:2, ')');

  finally
    SearchEngine.Free;
  end;
end.