unit AdaptiveDTW;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2024-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}


{$MODE OBJFPC}{$H+}

interface

uses
  SysUtils, Math;

type
  TFeatureArray = array of Double;

function ComputeDTW(const Seq1, Seq2: array of TFeatureArray; SakoeChibaRadius: Integer): Double;

implementation

function ComputeDTW(const Seq1, Seq2: array of TFeatureArray; SakoeChibaRadius: Integer): Double;
var
  DTW: array of array of Double;
  i, j, N, M, w: Integer;
  cost, minCost: Double;
begin
  N := Length(Seq1);
  M := Length(Seq2);
  SetLength(DTW, N + 1, M + 1);

  // Инициализация
  for i := 0 to N do
    for j := 0 to M do
      DTW[i, j] := Infinity;
  DTW[0, 0] := 0;

  // Вычисление DTW с окном Sakoe-Chiba
  for i := 1 to N do
  begin
    w := Min(SakoeChibaRadius, Abs(N - M));
    for j := Max(1, i - w) to Min(M, i + w) do
    begin
      cost := 0;
      // Проверяем, что Seq1[i - 1] и Seq2[j - 1] существуют
      if (i - 1 < Length(Seq1)) and (j - 1 < Length(Seq2)) then
      begin
        // Проверяем, что w не выходит за границы массивов
        for w := 0 to Min(High(Seq1[i - 1]), High(Seq2[j - 1])) do
          cost := cost + Sqr(Seq1[i - 1][w] - Seq2[j - 1][w]);
      end;
      cost := Sqrt(cost);
      
      minCost := Min(Min(DTW[i - 1, j], DTW[i, j - 1]), DTW[i - 1, j - 1]);
      DTW[i, j] := cost + minCost;
    end;
  end;

  Result := DTW[N, M] / (N + M); // Нормализация
end;

end.