unit DTWUnit;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2024-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

interface

uses
  SysUtils, Math;

type
  TFeatureArray = array of array of Double; // Массив признаков [время, параметры]

function DTWDistance(InputSeq, TemplateSeq: TFeatureArray): Double;

implementation

function Distance(A, B: array of Double): Double;
var
  i: Integer;
  Sum: Double;
begin
  Sum := 0;
  for i := 0 to High(A) do
    Sum := Sum + Sqr(A[i] - B[i]);
  Result := Sqrt(Sum);
end;

function DTWDistance(InputSeq, TemplateSeq: TFeatureArray): Double;
var
  DTW: array of array of Double;
  i, j: Integer;
begin
  SetLength(DTW, Length(InputSeq), Length(TemplateSeq));
  
  // Инициализация DTW
  DTW[0][0] := Distance(InputSeq[0], TemplateSeq[0]);
  for i := 1 to High(InputSeq) do
    DTW[i][0] := DTW[i - 1][0] + Distance(InputSeq[i], TemplateSeq[0]);
  for j := 1 to High(TemplateSeq) do
    DTW[0][j] := DTW[0][j - 1] + Distance(InputSeq[0], TemplateSeq[j]);
  
  // Заполнение матрицы
  for i := 1 to High(InputSeq) do
    for j := 1 to High(TemplateSeq) do
      DTW[i][j] := Distance(InputSeq[i], TemplateSeq[j]) +
                   Min(Min(DTW[i - 1][j],    // Вставка
                           DTW[i][j - 1]),   // Удаление
                           DTW[i - 1][j - 1]); // Совпадение
  
  Result := DTW[High(InputSeq)][High(TemplateSeq)];
end;

end.