program TicTacToe;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2024-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}
uses
  SysUtils;

type
  TBoard = array[1..3, 1..3] of Char;

procedure InitializeBoard(var Board: TBoard);
var
  i, j: Integer;
begin
  for i := 1 to 3 do
    for j := 1 to 3 do
      Board[i, j] := ' ';
end;

procedure DrawBoard(const Board: TBoard);
var
  i, j: Integer;
begin
  WriteLn('  1 2 3');
  for i := 1 to 3 do
  begin
    Write(i, ' ');
    for j := 1 to 3 do
    begin
      Write(Board[i, j]);
      if j < 3 then Write('|');
    end;
    WriteLn;
    if i < 3 then WriteLn('  -----');
  end;
end;

function CheckWin(const Board: TBoard; Player: Char): Boolean;
var
  i: Integer;
begin
  // Проверка строк и столбцов
  for i := 1 to 3 do
  begin
    if (Board[i, 1] = Player) and (Board[i, 2] = Player) and (Board[i, 3] = Player) then
      Exit(True);
    if (Board[1, i] = Player) and (Board[2, i] = Player) and (Board[3, i] = Player) then
      Exit(True);
  end;
  
  // Проверка диагоналей
  if (Board[1, 1] = Player) and (Board[2, 2] = Player) and (Board[3, 3] = Player) then
    Exit(True);
  if (Board[1, 3] = Player) and (Board[2, 2] = Player) and (Board[3, 1] = Player) then
    Exit(True);
  
  Result := False;
end;

function IsBoardFull(const Board: TBoard): Boolean;
var
  i, j: Integer;
begin
  for i := 1 to 3 do
    for j := 1 to 3 do
      if Board[i, j] = ' ' then
        Exit(False);
  Result := True;
end;

procedure PlayerMove(var Board: TBoard);
var
  x, y: Integer;
begin
  repeat
    Write('Введите строку (1-3): ');
    ReadLn(x);
    Write('Введите столбец (1-3): ');
    ReadLn(y);
  until (x >= 1) and (x <= 3) and (y >= 1) and (y <= 3) and (Board[x, y] = ' ');
  
  Board[x, y] := 'X';
end;

procedure ComputerMove(var Board: TBoard);
var
  i, j: Integer;
begin
  for i := 1 to 3 do
    for j := 1 to 3 do
      if Board[i, j] = ' ' then
      begin
        Board[i, j] := 'O';
        Exit;
      end;
end;

var
  Board: TBoard;
  GameOver: Boolean;
  Winner: Char;

begin
  InitializeBoard(Board);
  GameOver := False;
  
  while not GameOver do
  begin
    DrawBoard(Board);
    PlayerMove(Board);
    
    if CheckWin(Board, 'X') then
    begin
      DrawBoard(Board);
      WriteLn('Ты выиграл!');
      GameOver := True;
    end
    else if IsBoardFull(Board) then
    begin
      DrawBoard(Board);
      WriteLn('Ничья!');
      GameOver := True;
    end
    else
    begin
      ComputerMove(Board);
      
      if CheckWin(Board, 'O') then
      begin
        DrawBoard(Board);
        WriteLn('Компьютер выиграл!');
        GameOver := True;
      end
      else if IsBoardFull(Board) then
      begin
        DrawBoard(Board);
        WriteLn('Ничья!');
        GameOver := True;
      end;
    end;
  end;
end.