program test_mfcc;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2024-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}
uses
  SysUtils, Math, MFCCUnit;

const
  SampleRate = 16000;  // Частота дискретизации 16 кГц
  SignalLength = 256;  // Длина тестового сигнала (степень двойки для FFT)

var
  Signal: TDoubleArray;
  MFCC: TDoubleArray;
  i: Integer;

begin
  // Инициализация тестового сигнала (например, синусоида с частотой 440 Гц)
  SetLength(Signal, SignalLength);
  for i := 0 to High(Signal) do
    Signal[i] := Sin(2 * Pi * 440 * i / SampleRate);

  // Вычисление MFCC
  try
    MFCC := ComputeMFCC(Signal, SampleRate);

    // Вывод результатов
    Writeln('MFCC Coefficients:');
    for i := 0 to High(MFCC) do
      Writeln('MFCC[', i, '] = ', MFCC[i]:0:4);
  except
    on E: Exception do
      Writeln('Error: ', E.Message);
  end;
end.