unit ColorizerUnit;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

interface

uses
  Crt, SysUtils;

const
  LOG_FILE = 'aiconsole.log';  // Файл для логирования

  // Цвета
  LightRed = 12;     // Светло-красный
  LightGreen = 10;   // Светло-зеленый
  LightBlue = 9;     // Светло-синий
  Yellow = 14;       // Желтый
  LightMagenta = 13; // Светло-пурпурный
  LightCyan = 11;    // Светло-голубой
  White = 15;        // Белый

  // Уровни логирования
  LOG_INFO = 0;
  LOG_WARNING = 1;
  LOG_ERROR = 2;

procedure Log(const Message: String; LogLevel: Integer = LOG_INFO);
procedure ShowMessage(const Message: String; Color: Byte; LogLevel: Integer = LOG_INFO);
procedure ShowInfo(const Message: String);
procedure ShowWarning(const Message: String);
procedure ShowError(const Message: String);
procedure ShowSuccess(const Message: String);

implementation

procedure Log(const Message: String; LogLevel: Integer = LOG_INFO);
var
  LogFile: TextFile;
  LogLevelStr: String;
begin
  AssignFile(LogFile, LOG_FILE);
  if FileExists(LOG_FILE) then
    Append(LogFile)
  else
    Rewrite(LogFile);

  case LogLevel of
    LOG_INFO: LogLevelStr := 'INFO';
    LOG_WARNING: LogLevelStr := 'WARNING';
    LOG_ERROR: LogLevelStr := 'ERROR';
  else
    LogLevelStr := 'INFO';
  end;

  WriteLn(LogFile, FormatDateTime('yyyy-mm-dd hh:nn:ss', Now) + ' [' + LogLevelStr + '] - ' + Message);
  CloseFile(LogFile);
end;

procedure ShowMessage(const Message: String; Color: Byte; LogLevel: Integer = LOG_INFO);
begin
  TextColor(Color);
  WriteLn(Message);
  Log(Message, LogLevel);
  TextColor(White);
end;

procedure ShowInfo(const Message: String);
begin
  ShowMessage(Message, LightCyan, LOG_INFO);
end;

procedure ShowWarning(const Message: String);
begin
  ShowMessage(Message, Yellow, LOG_WARNING);
end;

procedure ShowError(const Message: String);
begin
  ShowMessage(Message, LightRed, LOG_ERROR);
end;

procedure ShowSuccess(const Message: String);
begin
  ShowMessage(Message, LightGreen, LOG_INFO);
end;

end.