unit CommonUnit;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

interface

uses
  SysUtils, DataUtils, MachineLearning, DecisionTree, RandomForest, NeuralNetwork;

type
  TModelType = (mtLinear, mtLogistic, mtKNN, mtSVM, mtDecisionTree, mtRandomForest, mtNeuralNetwork);
  TSVM = record
    weights: TDoubleArray;
    bias: Double;
  end;

var
  x: TDoubleMatrix;  // Данные
  y: TDoubleArray;   // Целевые значения
  model: TLinearRegression;  // Линейная регрессия
  logisticModel: TLogisticRegression;  // Логистическая регрессия
  knnModel: TKNN;  // Метод k-ближайших соседей
  svmModel: TSVM;  // Метод опорных векторов
  dtModel: TDecisionTree;  // Дерево решений
  rfModel: TRandomForest;  // Случайный лес
  nnModel: TNeuralNetwork;  // Нейронная сеть
  isDataLoaded: Boolean = False;  // Флаг загрузки данных
  isModelTrained: Boolean = False;  // Флаг обучения модели
  currentModel: TModelType;  // Текущая модель

function ArrayToString(const arr: array of Double): String;
function CalculateR2Score(const yTrue, yPred: TDoubleArray): Double;

implementation

function ArrayToString(const arr: array of Double): String;
var
  i: Integer;
begin
  Result := '';
  for i := 0 to High(arr) do
  begin
    if i > 0 then Result := Result + ', ';
    Result := Result + Format('%.4f', [arr[i]]);
  end;
  Result := '[' + Result + ']';
end;

function CalculateR2Score(const yTrue, yPred: TDoubleArray): Double;
var
  i: Integer;
  ssTotal, ssRes, yMean: Double;
begin
  // Вычисляем среднее значение
  yMean := 0;
  for i := 0 to High(yTrue) do
    yMean := yMean + yTrue[i];
  yMean := yMean / Length(yTrue);
  
  // Вычисляем SS Total и SS Residual
  ssTotal := 0;
  ssRes := 0;
  for i := 0 to High(yTrue) do
  begin
    ssTotal := ssTotal + Sqr(yTrue[i] - yMean);
    ssRes := ssRes + Sqr(yTrue[i] - yPred[i]);
  end;
  
  Result := 1 - (ssRes / ssTotal);
end;

end.