import numpy as np
from sklearn.ensemble import GradientBoostingRegressor
from sklearn.model_selection import train_test_split
from sklearn.metrics import mean_squared_error
from time import time

# Генерация тестовых данных (аналогично FreePascal-версии)
np.random.seed(42)
n_samples = 10000
n_features = 20

X = np.random.rand(n_samples, n_features) * 10
y = 2 * X[:, 0] + 3 * X[:, 1] - 1.5 * X[:, 2] + np.random.randn(n_samples)

# Разделение на train/test
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)

# Создание и обучение модели
start_time = time()

model = GradientBoostingRegressor(
    n_estimators=100,
    learning_rate=0.1,
    max_depth=3,
    min_samples_split=2,
    max_features='sqrt',
    random_state=42
)
model.fit(X_train, y_train)

train_time = time() - start_time

# Предсказание и оценка
start_time = time()
y_pred = model.predict(X_test)
predict_time = time() - start_time

mse = mean_squared_error(y_test, y_pred)

# Вывод результатов
print(f"=== sklearn Gradient Boosting Benchmark ===")
print(f"Training time: {train_time:.4f} seconds")
print(f"Prediction time ({len(X_test)} samples): {predict_time:.4f} seconds")
print(f"MSE: {mse:.6f}")
print(f"Model parameters:")
print(f"- n_estimators: {model.n_estimators}")
print(f"- learning_rate: {model.learning_rate}")
print(f"- max_depth: {model.max_depth}")
print(f"- min_samples_split: {model.min_samples_split}")
print(f"- max_features: {model.max_features}")