program GradientBoostingExample;{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

uses
  SysUtils, DataUtils, GradientBoosting,Math;

var
  x: TDoubleMatrix;
  y: TDoubleArray;
  model: TGradientBoosting;
  prediction: Double;
  i: Integer;
  minVals, maxVals: TDoubleArray;
  normalizedInput: TDoubleArray;
begin
  try
    // Загрузка данных
    if not FileExists('data.csv') then
    begin
      WriteLn('Ошибка: Файл data.csv не найден.');
      Exit;
    end;

    DataUtils.LoadData('data.csv', x);
    if Length(x) = 0 then
    begin
      WriteLn('Ошибка: Данные не загружены.');
      Exit;
    end;

    SetLength(y, Length(x));
    for i := 0 to High(x) do
    begin
      if Length(x[i]) = 0 then
      begin
        WriteLn('Ошибка: Пустая строка в данных.');
        Exit;
      end;
      y[i] := x[i][High(x[i])];  // Используем последний столбец как целевые значения
    end;

    // Нормализация данных
    DataUtils.NormalizeData(x);

    // Сохранение минимальных и максимальных значений для нормализации входных данных
    SetLength(minVals, Length(x[0]));
    SetLength(maxVals, Length(x[0]));
    for i := 0 to High(x[0]) do
    begin
      minVals[i] := MinValue(x[i]);
      maxVals[i] := MaxValue(x[i]);
    end;

    // Проверка данных перед обучением
    WriteLn('Количество строк в данных: ', Length(x));
    WriteLn('Количество столбцов в данных: ', Length(x[0]));

    // Обучение модели с улучшенными гиперпараметрами
    TrainGradientBoosting(model, x, y, 0.1, 200, 5, 2, 0.01);

    // Оценка качества модели на всех данных
    WriteLn('Средняя квадратичная ошибка (MSE) на всех данных: ', EvaluateModel(model, x, y):0:4);
    // Нормализация входных данных для предсказания
    normalizedInput := NormalizeInput([1.0, 2.0, 3.0], minVals, maxVals);
    // Предсказание
    prediction := PredictGradientBoosting(model, normalizedInput);
    WriteLn('Предсказание: ', prediction:0:4);
  except
    on E: Exception do
    begin
      WriteLn('Ошибка: ', E.Message);
    end;
  end;
end.