unit IntentRecognizer;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}{$RANGECHECKS ON}

interface

uses
  SysUtils, Classes, NLPCore, MachineLearning;

type
  TIntent = record
    Name: string;
    Patterns: TStringArray;
    Response: string;
  end;
  
  TIntentArray = array of TIntent;

  TIntentRecognizer = class
  private
    FIntents: TIntentArray;
    FTextProcessor: TTextProcessor;
    FModel: TLogisticRegression;
    FVocabulary: TStringArray;
    function BuildVocabulary: TStringArray;
  public
    constructor Create(const IntentsFile: string);
    destructor Destroy; override;
    function Recognize(const Text: string): string;
    procedure Train;
  end;

implementation

constructor TIntentRecognizer.Create(const IntentsFile: string);
var
  List: TStringList;
  I, J: Integer;
  Lines: TStringArray;
begin
  FTextProcessor := TTextProcessor.Create('stopwords.txt');
  
  List := TStringList.Create;
  try
    List.LoadFromFile(IntentsFile);
    SetLength(FIntents, List.Count);
    
    for I := 0 to List.Count - 1 do
    begin
      Lines := SplitString(List[I], '|');
      FIntents[I].Name := Lines[0];
      FIntents[I].Response := Lines[High(Lines)];
      
      SetLength(FIntents[I].Patterns, Length(Lines) - 2);
      for J := 1 to High(Lines) - 1 do
        FIntents[I].Patterns[J-1] := Lines[J];
    end;
  finally
    List.Free;
  end;
  
  FVocabulary := BuildVocabulary;
end;

destructor TIntentRecognizer.Destroy;
begin
  FTextProcessor.Free;
  inherited;
end;

function TIntentRecognizer.BuildVocabulary: TStringArray;
var
  I, J, K: Integer;
  Tokens: TTokenArray;
  UniqueWords: TStringList;
begin
  UniqueWords := TStringList.Create;
  UniqueWords.Sorted := True;
  UniqueWords.Duplicates := dupIgnore;
  
  try
    for I := 0 to High(FIntents) do
    begin
      for J := 0 to High(FIntents[I].Patterns) do
      begin
        Tokens := FTextProcessor.Tokenize(FIntents[I].Patterns[J]);
        Tokens := FTextProcessor.RemoveStopWords(Tokens);
        
        for K := 0 to High(Tokens) do
          UniqueWords.Add(Tokens[K].Lemma);
      end;
    end;
    
    SetLength(Result, UniqueWords.Count);
    for I := 0 to UniqueWords.Count - 1 do
      Result[I] := UniqueWords[I];
  finally
    UniqueWords.Free;
  end;
end;

procedure TIntentRecognizer.Train;
var
  I, J, K: Integer;
  X: TDoubleMatrix;
  Y: TDoubleArray;
  Pattern: string;
begin
  // TODO: Реализовать обучение модели
end;

function TIntentRecognizer.Recognize(const Text: string): string;
var
  I: Integer;
  BestScore: Double;
  CurrentScore: Double;
begin
  // TODO: Реализовать распознавание намерения
  Result := 'Извините, я не понял ваш вопрос. Можете переформулировать?';
end;

end.