import time
import numpy as np
from sklearn.linear_model import LinearRegression
from sklearn.tree import DecisionTreeRegressor
from sklearn.ensemble import RandomForestRegressor
from sklearn.neighbors import KNeighborsRegressor

NUM_SAMPLES = 1000
NUM_FEATURES = 10

def generate_test_data(problem_type='regression'):
    np.random.seed(42)
    X = np.random.rand(NUM_SAMPLES, NUM_FEATURES) * 10
    
    if problem_type == 'regression':
        y = 2*X[:,0] + 3*X[:,1] - 1.5*X[:,2] + np.random.randn(NUM_SAMPLES)
    else:
        y = (X[:,0] + X[:,1] > 10).astype(int)
    
    return X, y

def run_benchmark():
    X, y = generate_test_data('regression')
    
    # Decision Tree
    print("=== Decision Tree Benchmark ===")
    start = time.time()
    dt = DecisionTreeRegressor(max_depth=5, min_samples_split=2)
    dt.fit(X, y)
    elapsed = time.time() - start
    print(f"Training time: {elapsed:.4f} seconds")
    
    start = time.time()
    predictions = dt.predict(X)
    elapsed = time.time() - start
    print(f"Prediction time ({NUM_SAMPLES} samples): {elapsed:.4f} seconds")
    
    # Random Forest
    print("=== Random Forest Benchmark ===")
    start = time.time()
    rf = RandomForestRegressor(n_estimators=10, max_depth=5, min_samples_split=2)
    rf.fit(X, y)
    elapsed = time.time() - start
    print(f"Training time: {elapsed:.4f} seconds")
    
    start = time.time()
    predictions = rf.predict(X)
    elapsed = time.time() - start
    print(f"Prediction time ({NUM_SAMPLES} samples): {elapsed:.4f} seconds")

if __name__ == "__main__":
    run_benchmark()