unit ReportUtils;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

{$MODE OBJFPC}{$H+}

interface

uses
  SysUtils, GorgParser, KMeans, classes;

procedure SaveClustersToCSV(const filename: String; 
                          const alarms: TGorgAlarmArray;
                          const model: TKMeans);

implementation

procedure SaveClustersToCSV(const filename: String;
                           const alarms: TGorgAlarmArray;
                           const model: TKMeans);
var
  sl: TStringList;
  i, cluster: Integer;
begin
  sl := TStringList.Create;
  try
    sl.Add('Time,Message,Cluster,ClusterName');
    
    for i := 0 to High(alarms) do
    begin
      cluster := PredictKMeans(model, PrepareFeatures([alarms[i]])[0]);
      sl.Add(Format('"%02d:%02d","%s",%d,"%s"',
        [alarms[i].hour, alarms[i].minute,
         alarms[i].message, cluster,
         AnalyzeCluster(model.centroids[cluster])]));
    end;
    
    sl.SaveToFile(filename);
  finally
    sl.Free;
  end;
end;

end.