unit SimpleChatbot;

{
    Part of AdvancedChatAI.
    For GNU/Linux 64 bit version.
    Version: 1.
    Written on FreePascal (https://freepascal.org/).
    Copyright (C) 2025-2026 Artyomov Alexander
    Used https://chat.deepseek.com/
    http://self-made-free.ru/
    aralni@mail.ru

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
}

interface

uses
  TextAnalyzer, IntentRecognizer;

type
  TChatbot = class
  private
    FAnalyzer: TTextAnalyzer;
    FIntentRecognizer: TIntentRecognizer;
  public
    constructor Create;
    function ProcessMessage(const Message: string): string;
  end;

implementation

constructor TChatbot.Create;
begin
  FAnalyzer := TTextAnalyzer.Create('dict.txt');
  FIntentRecognizer := TIntentRecognizer.Create('intents.txt');
end;

function TChatbot.ProcessMessage(const Message: string): string;
var
  Lemmas: TStringArray;
begin
  Lemmas := FAnalyzer.AnalyzeText(Message);
  Result := FIntentRecognizer.GetResponse(Lemmas);
end;